/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.adapter;

import cn.ximcloud.homekit.core.starter.config.HomeKitConfig;
import cn.ximcloud.homekit.core.starter.config.HomeKitDataSourceConfig;
import cn.ximcloud.homekit.core.starter.core.condition.BaseOnDatabaseHomeKitCondition;
import cn.ximcloud.homekit.core.starter.core.condition.EmbeddedDataBaseCondition;
import cn.ximcloud.homekit.core.starter.core.condition.SimpleDemoHomeKitCondition;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitService;
import cn.ximcloud.homekit.core.starter.core.service.impl.BaseOnDataBaseHomeKitService;
import cn.ximcloud.homekit.core.starter.core.service.impl.SimpleDemoHomeKitService;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAccessoryConfigRepository;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAccessoryRepository;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAuthInfoRepository;
import cn.ximcloud.homekit.core.starter.repository.HomeKitUserRepository;
import cn.ximcloud.homekit.core.starter.utils.HomekitAccessoryBuilder;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@AutoConfigureBefore(value={DataSource.class})
public class HomeKitServiceAdapter {
    private static final Logger log = LoggerFactory.getLogger(HomeKitServiceAdapter.class);
    private final HomeKitAuthInfoRepository homeKitAuthInfoRepository;
    private final HomeKitUserRepository homeKitUserRepository;
    private final HomeKitConfig homeKitConfig;
    private final HomeKitAccessoryConfigRepository homeKitAccessoryConfigRepository;
    private final HomeKitDataSourceConfig homeKitDataSourceConfig;
    private final HomeKitAccessoryRepository homeKitAccessoryRepository;
    private final HomekitAccessoryBuilder homekitAccessoryBuilder;

    public HomeKitServiceAdapter(HomeKitAuthInfoRepository homeKitAuthInfoRepository, HomeKitUserRepository homeKitUserRepository, HomeKitConfig homeKitConfig, HomeKitAccessoryConfigRepository homeKitAccessoryConfigRepository, HomeKitDataSourceConfig homeKitDataSourceConfig, HomeKitAccessoryRepository homeKitAccessoryRepository, HomekitAccessoryBuilder homekitAccessoryBuilder) {
        this.homeKitAuthInfoRepository = homeKitAuthInfoRepository;
        this.homeKitUserRepository = homeKitUserRepository;
        this.homeKitConfig = homeKitConfig;
        this.homeKitAccessoryConfigRepository = homeKitAccessoryConfigRepository;
        this.homeKitDataSourceConfig = homeKitDataSourceConfig;
        this.homeKitAccessoryRepository = homeKitAccessoryRepository;
        this.homekitAccessoryBuilder = homekitAccessoryBuilder;
    }

    @Bean
    @Conditional(value={SimpleDemoHomeKitCondition.class})
    public HomeKitService generateSimpleDemoHomeKitServiceWithCondition() {
        log.info("using simple demo homekit service");
        return new SimpleDemoHomeKitService(this.homeKitConfig);
    }

    @Bean
    @Conditional(value={EmbeddedDataBaseCondition.class})
    public HomeKitService generateEmbeddedDataBaseHomeKitServiceWithCondition() {
        log.info("using base on database homekit service");
        return new BaseOnDataBaseHomeKitService(this.homeKitAuthInfoRepository, this.homeKitUserRepository, this.homeKitConfig, this.homeKitAccessoryConfigRepository, this.homeKitDataSourceConfig, this.homeKitAccessoryRepository, this.homekitAccessoryBuilder);
    }

    @Bean
    @Conditional(value={BaseOnDatabaseHomeKitCondition.class})
    public HomeKitService generateDataBaseHomeKitServiceWithCondition() {
        log.info("using base on database homekit service");
        return new BaseOnDataBaseHomeKitService(this.homeKitAuthInfoRepository, this.homeKitUserRepository, this.homeKitConfig, this.homeKitAccessoryConfigRepository, this.homeKitDataSourceConfig, this.homeKitAccessoryRepository, this.homekitAccessoryBuilder);
    }

    static {
        log.info("init homekit service adapter");
    }
}

