/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.bootstrap;

import cn.ximcloud.homekit.core.starter.config.HomeKitConfig;
import cn.ximcloud.homekit.core.starter.core.adapter.HomeKitDataSourceAdapter;
import cn.ximcloud.homekit.core.starter.core.adapter.HomeKitServiceAdapter;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitService;
import cn.ximcloud.homekit.core.starter.utils.QrToConsole;
import io.github.hapjava.accessories.HomekitAccessory;
import io.github.hapjava.server.HomekitAuthInfo;
import io.github.hapjava.server.impl.HomekitRoot;
import io.github.hapjava.server.impl.HomekitServer;
import io.github.hapjava.server.impl.crypto.HAPSetupCodeUtils;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Service;

@Service
@Configuration
@AutoConfigureAfter(value={HomeKitConfig.class, HomeKitDataSourceAdapter.class, HomeKitServiceAdapter.class})
public class HomeKitBootStrapServer
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(HomeKitBootStrapServer.class);
    private final HomeKitConfig homeKitConfig;
    private final HomeKitService homeKitService;
    private HomekitRoot homekitRoot;

    public HomeKitBootStrapServer(HomeKitConfig homeKitConfig, HomeKitService homeKitService) {
        this.homeKitConfig = homeKitConfig;
        this.homeKitService = homeKitService;
    }

    private static void printAccessoryLog(HomekitAccessory accessory) {
        log.info("add accessory [Id:{},Name:{},SerialNumber:{},Model:{},Manufacturer:{},FirmwareRevision:{}]", new Object[]{accessory.getId(), accessory.getName().get(), accessory.getSerialNumber().get(), accessory.getModel().get(), accessory.getManufacturer().get(), accessory.getFirmwareRevision().get()});
    }

    public void destroy() {
        this.homekitRoot.stop();
    }

    public void afterPropertiesSet() {
        HomekitAuthInfo ximCloudHomeKitServiceAuthInfo = this.homeKitService.getAuthInfo();
        this.homekitRoot = new HomekitServer(this.homeKitConfig.getPort().intValue()).createBridge(ximCloudHomeKitServiceAuthInfo, this.homeKitConfig.getLabel(), this.homeKitConfig.getManufacturer(), this.homeKitConfig.getModel(), this.homeKitConfig.getSerialNumber(), this.homeKitConfig.getFirmwareRevision(), this.homeKitConfig.getHardwareRevision());
        this.addAccessories();
        this.homekitRoot.start();
        this.printQr(ximCloudHomeKitServiceAuthInfo);
    }

    private void addAccessories() {
        this.homeKitService.getAccessories().stream().sorted(Comparator.comparing(HomekitAccessory::getId)).peek(HomeKitBootStrapServer::printAccessoryLog).forEach(arg_0 -> ((HomekitRoot)this.homekitRoot).addAccessory(arg_0));
    }

    private void printQr(HomekitAuthInfo ximCloudHomeKitAuthInfo) {
        String pin = ximCloudHomeKitAuthInfo.getPin();
        String shortPin = pin.replace("-", "");
        String setupId = ximCloudHomeKitAuthInfo.getSetupId();
        String setupUri = HAPSetupCodeUtils.getSetupURI((String)shortPin, (String)setupId, (int)2);
        log.info(QrToConsole.transformQr(setupUri));
        log.info("pin:[{}],setupId:[{}],QR Url:[{}]", new Object[]{pin, setupId, setupUri});
    }
}

