/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.service.impl;

import cn.ximcloud.homekit.core.starter.auth.BaseOnDataBaseHomeKitAuthInfo;
import cn.ximcloud.homekit.core.starter.config.HomeKitConfig;
import cn.ximcloud.homekit.core.starter.config.HomeKitDataSourceConfig;
import cn.ximcloud.homekit.core.starter.constants.HomeKitAccessoryTypeEnum;
import cn.ximcloud.homekit.core.starter.core.accessories.DemoLightAccessory;
import cn.ximcloud.homekit.core.starter.core.accessories.DemoSwitchAccessory;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitService;
import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryEntity;
import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryMethodEntity;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAccessoryConfigRepository;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAccessoryRepository;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAuthInfoRepository;
import cn.ximcloud.homekit.core.starter.repository.HomeKitUserRepository;
import cn.ximcloud.homekit.core.starter.utils.HomeKitAccessoryScanner;
import cn.ximcloud.homekit.core.starter.utils.HomekitAccessoryBuilder;
import cn.ximcloud.homekit.core.starter.utils.HomekitAccessoryCoverUtil;
import io.github.hapjava.accessories.HomekitAccessory;
import io.github.hapjava.server.HomekitAuthInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class BaseOnDataBaseHomeKitService
implements HomeKitService {
    private static final Logger log = LoggerFactory.getLogger(BaseOnDataBaseHomeKitService.class);
    private final HomeKitAccessoryConfigRepository homeKitAccessoryConfigRepository;
    private final HomeKitConfig homeKitConfig;
    private final HomeKitAuthInfoRepository homeKitAuthInfoRepository;
    private final HomeKitUserRepository homeKitUserRepository;
    private final HomeKitDataSourceConfig homeKitDataSourceConfig;
    private final HomeKitAccessoryRepository homeKitAccessoryRepository;
    private final HomekitAccessoryBuilder homekitAccessoryBuilder;

    public BaseOnDataBaseHomeKitService(HomeKitAuthInfoRepository homeKitAuthInfoRepository, HomeKitUserRepository homeKitUserRepository, HomeKitConfig homeKitConfig, HomeKitAccessoryConfigRepository homeKitAccessoryConfigRepository, HomeKitDataSourceConfig homeKitDataSourceConfig, HomeKitAccessoryRepository homeKitAccessoryRepository, HomekitAccessoryBuilder homekitAccessoryBuilder) {
        this.homeKitAuthInfoRepository = homeKitAuthInfoRepository;
        this.homeKitUserRepository = homeKitUserRepository;
        this.homeKitConfig = homeKitConfig;
        this.homeKitAccessoryConfigRepository = homeKitAccessoryConfigRepository;
        this.homeKitDataSourceConfig = homeKitDataSourceConfig;
        this.homeKitAccessoryRepository = homeKitAccessoryRepository;
        this.homekitAccessoryBuilder = homekitAccessoryBuilder;
        this.handlerHomeKitAccessoryMetaData();
    }

    @Override
    public HomekitAuthInfo getAuthInfo() {
        return new BaseOnDataBaseHomeKitAuthInfo(this.homeKitAuthInfoRepository, this.homeKitUserRepository);
    }

    @Override
    public List<HomekitAccessory> getAccessories() {
        ArrayList<HomekitAccessory> accessories = new ArrayList<HomekitAccessory>();
        this.addDefaultAccessories(accessories);
        return accessories;
    }

    @Transactional(rollbackFor={Exception.class})
    public void handlerHomeKitAccessoryMetaData() {
        HomeKitAccessoryScanner.scanHomeKitAccessory().forEach(homeKitAccessoryClass -> this.extracted((Class<?>)homeKitAccessoryClass, HomeKitAccessoryTypeEnum.ACCESSORY));
        HomeKitAccessoryScanner.scanHomeKitAccessoryOptionalCharacteristic().forEach(optionalCharacteristic -> this.extracted((Class<?>)optionalCharacteristic, HomeKitAccessoryTypeEnum.OPTIONAL_CHARACTERISTIC));
    }

    private void extracted(Class<?> homeKitAccessoryClass, HomeKitAccessoryTypeEnum type) {
        if (!this.homeKitAccessoryRepository.findByClazz(homeKitAccessoryClass).isPresent()) {
            HomeKitAccessoryEntity entity = new HomeKitAccessoryEntity();
            entity.setClazz(homeKitAccessoryClass);
            entity.setType(type);
            ArrayList<HomeKitAccessoryMethodEntity> methodList = new ArrayList<HomeKitAccessoryMethodEntity>();
            Set allMethods = ReflectionUtils.getAllMethods(homeKitAccessoryClass, (Predicate[])new Predicate[0]);
            allMethods.forEach(method -> {
                HomeKitAccessoryMethodEntity homeKitAccessoryMethodEntity = HomekitAccessoryCoverUtil.coverToHomeKitAccessoryMethodEntity(method);
                homeKitAccessoryMethodEntity.setHomeKitAccessory(entity);
                methodList.add(homeKitAccessoryMethodEntity);
            });
            entity.setHomekitAccessoryMethodList(methodList);
            this.homeKitAccessoryRepository.save(entity);
        }
    }

    private void addDefaultAccessories(List<HomekitAccessory> accessories) {
        this.generateDemoAccessoriesWithCondition(accessories);
        this.generateFromDataBaseAccessories(accessories);
    }

    private void generateDemoAccessoriesWithCondition(List<HomekitAccessory> accessories) {
        if (this.homeKitConfig.isAddDemo()) {
            accessories.add(DemoSwitchAccessory.generateSimpleDemoSwitchAccessory());
            accessories.add((HomekitAccessory)new DemoLightAccessory());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void generateFromDataBaseAccessories(List<HomekitAccessory> accessories) {
        if (this.homeKitConfig.isAddDemo() && this.homeKitAccessoryConfigRepository.count() == 0L) {
            this.homeKitAccessoryConfigRepository.save(this.homekitAccessoryBuilder.buildDemoHomeKitAccessory());
        }
        Iterable homeKitAccessoryConfigEntities = this.homeKitAccessoryConfigRepository.findAll();
        homeKitAccessoryConfigEntities.forEach(homeKitAccessoryConfigEntity -> accessories.add(HomekitAccessoryCoverUtil.coverToHomekitAccessory(homeKitAccessoryConfigEntity)));
    }
}

