/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.autoconfig;

import cn.ximcloud.homekit.core.starter.autoconfig.HomeKitServiceAutoConfiguration;
import cn.ximcloud.homekit.core.starter.autoconfig.condition.EmbeddedDataBaseCondition;
import cn.ximcloud.homekit.core.starter.autoconfig.condition.SimpleDemoHomeKitCondition;
import cn.ximcloud.homekit.core.starter.autoconfig.properties.HomeKitDataSourceProperties;
import cn.ximcloud.homekit.core.starter.constants.DataSourceConstant;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Optional;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.stereotype.Component;

@Component
@Configuration
@AutoConfigureAfter(value={HomeKitDataSourceProperties.class})
@EntityScan(value={"cn.ximcloud.homekit.core.starter.entity"})
@EnableJpaRepositories(value={"cn.ximcloud.homekit.core.starter.repository"})
@AutoConfigureBefore(value={DataSource.class, HomeKitServiceAutoConfiguration.class})
public class HomeKitDataAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(HomeKitDataAutoConfiguration.class);
    private final HomeKitDataSourceProperties homeKitDataSourceProperties;

    public HomeKitDataAutoConfiguration(HomeKitDataSourceProperties homeKitDataSourceProperties) {
        this.homeKitDataSourceProperties = homeKitDataSourceProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={DataSource.class})
    @Conditional(value={SimpleDemoHomeKitCondition.class})
    public DataSource generateUnUsedDataSource() {
        log.info("generate unused DataSource");
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName("org.h2.Driver");
        hikariConfig.setJdbcUrl("jdbc:h2:mem:unused");
        hikariConfig.setUsername("sa");
        hikariConfig.setPassword("sa");
        return new HikariDataSource(hikariConfig);
    }

    @Bean
    @ConditionalOnMissingBean(value={DataSource.class})
    @Conditional(value={EmbeddedDataBaseCondition.class})
    public DataSource generateEmbeddedDataSource() {
        log.info("generate Embedded DataSource");
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName("org.h2.Driver");
        String jdbcUrl = this.generateJdbcUrl();
        hikariConfig.setJdbcUrl(jdbcUrl);
        hikariConfig.setUsername("sa");
        hikariConfig.setPassword("sa");
        log.info("the jdbc url is:[{}] ,username:[{}],password:[{}]", new Object[]{jdbcUrl, hikariConfig.getUsername(), hikariConfig.getPassword()});
        return new HikariDataSource(hikariConfig);
    }

    private String generateJdbcUrl() {
        if (DataSourceConstant.EMBEDDED.equals((Object)this.homeKitDataSourceProperties.getType())) {
            return "jdbc:h2:mem:ximcloud_homekit";
        }
        return "jdbc:h2:file:".concat(Optional.ofNullable(this.homeKitDataSourceProperties.getFile()).orElse("./db/ximcloud_homekit"));
    }

    static {
        log.info("init datasource auto configuration");
    }
}

