/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.auth;

import cn.ximcloud.homekit.core.starter.core.auth.XIMCloudHomeKitAuthInfo;
import cn.ximcloud.homekit.core.starter.entity.HomeKitAuthInfoEntity;
import cn.ximcloud.homekit.core.starter.entity.HomeKitUserEntity;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitUserVo;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAuthInfoRepository;
import cn.ximcloud.homekit.core.starter.repository.HomeKitUserRepository;
import com.google.common.collect.Lists;
import io.github.hapjava.server.impl.HomekitServer;
import io.github.hapjava.server.impl.HomekitUtils;
import io.github.hapjava.server.impl.crypto.HAPSetupCodeUtils;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseOnDataBaseHomeKitAuthInfo
implements XIMCloudHomeKitAuthInfo {
    private static final Logger log = LoggerFactory.getLogger(BaseOnDataBaseHomeKitAuthInfo.class);
    private final HomeKitUserRepository homeKitUserRepository;
    private final HomeKitAuthInfoEntity homeKitAuthInfoEntity;

    public BaseOnDataBaseHomeKitAuthInfo(HomeKitAuthInfoRepository homeKitAuthInfoRepository, HomeKitUserRepository homeKitUserRepository) {
        this.homeKitUserRepository = homeKitUserRepository;
        HomeKitAuthInfoEntity homeKitAuthInfo = homeKitAuthInfoRepository.findById(1).orElseGet(() -> {
            try {
                return new HomeKitAuthInfoEntity(HomekitServer.generatePin(), HomekitServer.generateMac(), HomekitServer.generateSalt(), HomekitUtils.generateKey(), HAPSetupCodeUtils.generateSetupId());
            }
            catch (InvalidAlgorithmParameterException e) {
                log.error("generate HomeKitAuthInfo error", (Throwable)e);
                throw new IllegalArgumentException("generate HomeKitAuthInfo error", e);
            }
        });
        homeKitAuthInfoRepository.update(homeKitAuthInfo);
        this.homeKitAuthInfoEntity = homeKitAuthInfo;
        log.info("The PIN for pairing is {}", (Object)homeKitAuthInfo.getPin());
    }

    public String getPin() {
        return this.homeKitAuthInfoEntity.getPin();
    }

    public String getMac() {
        return this.homeKitAuthInfoEntity.getMac();
    }

    public BigInteger getSalt() {
        return this.homeKitAuthInfoEntity.getSalt();
    }

    public byte[] getPrivateKey() {
        return this.homeKitAuthInfoEntity.getPrivateKey();
    }

    public String getSetupId() {
        return this.homeKitAuthInfoEntity.getSetupId();
    }

    public void createUser(String userName, byte[] publicKey) {
        Optional<HomeKitUserEntity> homeKitUser = this.homeKitUserRepository.findByUserName(userName);
        if (!homeKitUser.isPresent()) {
            this.homeKitUserRepository.save(new HomeKitUserEntity(userName, publicKey));
            log.info("Added user for {}", (Object)userName);
        } else {
            log.warn("Already have an user for {}", (Object)userName);
        }
    }

    public void removeUser(String userName) {
        Optional<HomeKitUserEntity> homeKitUser = this.homeKitUserRepository.findByUserName(userName);
        if (homeKitUser.isPresent()) {
            log.info("Removed user for {}", (Object)userName);
            this.homeKitUserRepository.delete(homeKitUser.get());
        } else {
            log.warn("the user {} not found", (Object)userName);
        }
    }

    public byte[] getUserPublicKey(String userName) {
        Optional<HomeKitUserEntity> homeKitUser = this.homeKitUserRepository.findByUserName(userName);
        if (homeKitUser.isPresent()) {
            return homeKitUser.get().getPublicKey();
        }
        log.warn("the user {} not found", (Object)userName);
        return new byte[0];
    }

    public boolean hasUser() {
        return this.homeKitUserRepository.count() > 0L;
    }

    @Override
    public List<HomeKitUserVo> getUserList() {
        return Lists.newArrayList((Iterable)this.homeKitUserRepository.findAll()).stream().map(user -> HomeKitUserVo.builder().id(user.getId()).name(user.getUserName()).publicKey(user.getPublicKey()).build()).collect(Collectors.toList());
    }

    @Override
    public boolean hasUser(String userName) {
        return this.getUserPublicKey(userName).length == 0;
    }

    public BaseOnDataBaseHomeKitAuthInfo(HomeKitUserRepository homeKitUserRepository, HomeKitAuthInfoEntity homeKitAuthInfoEntity) {
        this.homeKitUserRepository = homeKitUserRepository;
        this.homeKitAuthInfoEntity = homeKitAuthInfoEntity;
    }
}

