/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.auth;

import cn.ximcloud.homekit.core.starter.core.auth.XIMCloudHomeKitAuthInfo;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitUserVo;
import io.github.hapjava.server.impl.HomekitServer;
import io.github.hapjava.server.impl.crypto.HAPSetupCodeUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDemoHomeKitAuthInfo
implements XIMCloudHomeKitAuthInfo {
    private static final Logger log = LoggerFactory.getLogger(SimpleDemoHomeKitAuthInfo.class);
    private final String pin;
    private final String mac;
    private final BigInteger salt;
    private final byte[] privateKey;
    private final String setupId;
    private Map<String, byte[]> userMap = new ConcurrentHashMap<String, byte[]>();
    private final transient File authFile = new File("auth-state.bin");

    public SimpleDemoHomeKitAuthInfo() {
        if (this.authFile.exists()) {
            try (ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(this.authFile));){
                log.debug("Using persisted auth");
                SimpleDemoHomeKitAuthInfo simpleDemoHomeKitAuthInfo = (SimpleDemoHomeKitAuthInfo)objectInputStream.readObject();
                this.pin = simpleDemoHomeKitAuthInfo.pin;
                this.mac = simpleDemoHomeKitAuthInfo.mac;
                this.salt = simpleDemoHomeKitAuthInfo.salt;
                this.privateKey = simpleDemoHomeKitAuthInfo.privateKey;
                this.userMap = simpleDemoHomeKitAuthInfo.userMap;
                this.setupId = simpleDemoHomeKitAuthInfo.setupId;
            }
        } else {
            this.pin = HomekitServer.generatePin();
            this.mac = HomekitServer.generateMac();
            this.salt = HomekitServer.generateSalt();
            this.privateKey = HomekitServer.generateKey();
            this.setupId = HAPSetupCodeUtils.generateSetupId();
            this.notifyChanged();
        }
        log.info("The PIN for pairing is {}", (Object)this.pin);
    }

    private void notifyChanged() {
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.authFile));){
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
        }
        catch (IOException e) {
            log.error("write to file error", (Throwable)e);
        }
    }

    public String getPin() {
        return this.pin;
    }

    public String getMac() {
        return this.mac;
    }

    public BigInteger getSalt() {
        return this.salt;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    public String getSetupId() {
        return this.setupId;
    }

    public void createUser(String username, byte[] publicKey) {
        if (!this.userMap.containsKey(username)) {
            this.userMap.putIfAbsent(username, publicKey);
            log.info("Added user for {}", (Object)username);
        } else {
            log.warn("Already have this user for {}", (Object)username);
        }
        this.notifyChanged();
    }

    public void removeUser(String userName) {
        if (this.userMap.containsKey(userName)) {
            this.userMap.remove(userName);
            log.info("Removed pairing for {}", (Object)userName);
        } else {
            log.warn("the user {} not found", (Object)userName);
        }
        this.notifyChanged();
    }

    public byte[] getUserPublicKey(String userName) {
        if (this.userMap.containsKey(userName)) {
            return this.userMap.get(userName);
        }
        log.warn("the user {} not found", (Object)userName);
        return new byte[0];
    }

    public boolean hasUser() {
        return !this.userMap.isEmpty();
    }

    @Override
    public List<HomeKitUserVo> getUserList() {
        return this.userMap.entrySet().stream().map(entity -> HomeKitUserVo.builder().name((String)entity.getKey()).publicKey((byte[])entity.getValue()).build()).collect(Collectors.toList());
    }

    @Override
    public boolean hasUser(String userName) {
        return this.getUserPublicKey(userName).length == 0;
    }
}

