/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.bootstrap;

import cn.ximcloud.homekit.core.starter.autoconfig.HomeKitDataAutoConfiguration;
import cn.ximcloud.homekit.core.starter.autoconfig.HomeKitServiceAutoConfiguration;
import cn.ximcloud.homekit.core.starter.autoconfig.properties.HomeKitProperties;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitService;
import cn.ximcloud.homekit.core.starter.util.QrToConsole;
import io.github.hapjava.accessories.HomekitAccessory;
import io.github.hapjava.server.HomekitAuthInfo;
import io.github.hapjava.server.impl.HomekitRoot;
import io.github.hapjava.server.impl.HomekitServer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Service;

@Service
@Configuration
@AutoConfigureAfter(value={HomeKitDataAutoConfiguration.class, HomeKitServiceAutoConfiguration.class})
public class HomeKitBootStrapServer
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(HomeKitBootStrapServer.class);
    private final HomeKitProperties homeKitProperties;
    private final HomeKitService homeKitService;
    private volatile boolean flag = false;
    private HomekitRoot homekitRoot;
    private final List<HomekitAccessory> accessoryLake = new ArrayList<HomekitAccessory>();
    private static final String UN_SET = "unset";

    public HomeKitBootStrapServer(HomeKitProperties homeKitProperties, HomeKitService homeKitService) {
        this.homeKitProperties = homeKitProperties;
        this.homeKitService = homeKitService;
    }

    public void destroy() {
        this.stopServer();
    }

    public void afterPropertiesSet() {
        this.homekitRoot = new HomekitServer(this.homeKitProperties.getPort().intValue()).createBridge((HomekitAuthInfo)this.homeKitService.getAuthInfo(), this.homeKitProperties.getLabel(), this.homeKitProperties.getManufacturer(), this.homeKitProperties.getModel(), this.homeKitProperties.getSerialNumber(), this.homeKitProperties.getFirmwareRevision(), this.homeKitProperties.getHardwareRevision());
        this.checkAndAddAccessories();
        if (this.homeKitProperties.isAutoStart()) {
            this.homekitRoot.start();
        }
        QrToConsole.printQr(this.homeKitService.getAuthInfo());
        this.flag = true;
    }

    public boolean isRunning() {
        return this.flag;
    }

    public synchronized void startServer() {
        this.homekitRoot = new HomekitServer(this.homeKitProperties.getPort().intValue()).createBridge((HomekitAuthInfo)this.homeKitService.getAuthInfo(), this.homeKitProperties.getLabel(), this.homeKitProperties.getManufacturer(), this.homeKitProperties.getModel(), this.homeKitProperties.getSerialNumber(), this.homeKitProperties.getFirmwareRevision(), this.homeKitProperties.getHardwareRevision());
        this.checkAndAddAccessories();
        this.homekitRoot.start();
        QrToConsole.printQr(this.homeKitService.getAuthInfo());
        this.flag = true;
    }

    public synchronized void stopServer() {
        this.releaseAllAccessories();
        this.homekitRoot.stop();
        this.flag = false;
    }

    public List<HomekitAccessory> getCurrentRunningHomeKitAccessories() {
        return this.accessoryLake;
    }

    private void checkAndAddAccessories() {
        this.homeKitService.getAccessories().stream().sorted(Comparator.comparing(HomekitAccessory::getId)).filter(accessory -> {
            if (accessory.getId() == 1) {
                log.warn("accessory [{}] has a warn id number 1", accessory);
                return false;
            }
            return true;
        }).peek(HomeKitBootStrapServer::printAccessoryLog).peek(this::cacheToAccessoryLake).forEach(arg_0 -> ((HomekitRoot)this.homekitRoot).addAccessory(arg_0));
    }

    private static void printAccessoryLog(HomekitAccessory accessory) {
        log.info("add accessory [Id:{},Name:{},SerialNumber:{},Model:{},Manufacturer:{},FirmwareRevision:{}]", new Object[]{accessory.getId(), accessory.getName().join(), Optional.ofNullable(accessory.getSerialNumber()).map(CompletableFuture::join).orElse(UN_SET), Optional.ofNullable(accessory.getModel()).map(CompletableFuture::join).orElse(UN_SET), Optional.ofNullable(accessory.getManufacturer()).map(CompletableFuture::join).orElse(UN_SET), Optional.ofNullable(accessory.getFirmwareRevision()).map(CompletableFuture::join).orElse(UN_SET)});
    }

    private void releaseAllAccessories() {
        this.accessoryLake.forEach(accessory -> this.homekitRoot.removeAccessory(accessory));
    }

    private void cacheToAccessoryLake(HomekitAccessory homekitAccessory) {
        this.accessoryLake.add(homekitAccessory);
    }
}

