/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.controller;

import cn.ximcloud.homekit.core.starter.core.service.WebHomeKitService;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitAccessoryDetailVo;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitAccessoryVo;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitQrCodeAndPinCodeVo;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"homekit"})
public class HomeKitController {
    private final WebHomeKitService webHomeKitService;

    public HomeKitController(WebHomeKitService webHomeKitService) {
        this.webHomeKitService = webHomeKitService;
    }

    @GetMapping(value={"initialization"})
    public ModelAndView initialization() {
        return new ModelAndView("op_coming_soon");
    }

    @GetMapping(value={"", "index"})
    public ModelAndView index() {
        ModelAndView homekitAccessory = new ModelAndView("homekitAccessory");
        homekitAccessory.addObject("homeKitList", this.webHomeKitService.getHomeKitList());
        return homekitAccessory;
    }

    @GetMapping(value={"getQrCodeAndPinCode"})
    public HomeKitQrCodeAndPinCodeVo getQrCodeAndPinCode() {
        return this.webHomeKitService.getQrCodeAndPinCode();
    }

    @GetMapping(value={"homeKitList"})
    public List<HomeKitAccessoryVo> getHomeKitList() {
        return this.webHomeKitService.getHomeKitList();
    }

    @GetMapping(value={"homeKit/{id}"})
    public HomeKitAccessoryVo getHomeKit(@PathVariable(value="id") Integer id) {
        return this.webHomeKitService.getHomeKit(id);
    }

    @GetMapping(value={"homeKitMethod/{homeKitId}"})
    public Object getHomeKitMethod(@PathVariable(value="homeKitId") Integer homeKitId, Boolean isDefault) {
        return this.webHomeKitService.getHomeKitMethod(homeKitId, isDefault);
    }

    @GetMapping(value={"homeKitMethod/{homeKitId}/{homeKitMethodId}"})
    public Object getHomeKitMethod(@PathVariable(value="homeKitId") Integer homeKitId, @PathVariable(value="homeKitMethodId") Integer homeKitMethodId, Boolean isDefault) {
        return this.webHomeKitService.getHomeKitMethod(homeKitId, homeKitMethodId, isDefault);
    }

    @GetMapping(value={"homeKitSwitch/{flag}"})
    public Object homeKitSwitch(@PathVariable(value="flag") boolean flag) {
        return this.webHomeKitService.homeKitSwitch(flag);
    }

    @GetMapping(value={"currentReloadedHomeKitAccessories"})
    public List<HomeKitAccessoryDetailVo> currentReloadedHomeKitAccessories() {
        return this.webHomeKitService.getCurrentReloadedHomeKitAccessories();
    }
}

