/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.service.impl;

import cn.ximcloud.homekit.core.starter.autoconfig.properties.HomeKitProperties;
import cn.ximcloud.homekit.core.starter.core.auth.SimpleDemoHomeKitAuthInfo;
import cn.ximcloud.homekit.core.starter.core.auth.XIMCloudHomeKitAuthInfo;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitService;
import cn.ximcloud.homekit.core.starter.util.homekit.HomeKitAccessoryScanner;
import io.github.hapjava.accessories.HomekitAccessory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDemoHomeKitServiceImpl
implements HomeKitService {
    private static final Logger log = LoggerFactory.getLogger(SimpleDemoHomeKitServiceImpl.class);
    protected static final String DEMO_ACCESSORY_PACKAGE_PATH = "cn.ximcloud.homekit.core.starter.core.accessories";
    private final HomeKitProperties homeKitProperties;
    private final XIMCloudHomeKitAuthInfo homeKitAuthInfo = new SimpleDemoHomeKitAuthInfo();
    private List<HomekitAccessory> accessories;

    public SimpleDemoHomeKitServiceImpl(HomeKitProperties homeKitProperties) {
        this.homeKitProperties = homeKitProperties;
    }

    @Override
    public XIMCloudHomeKitAuthInfo getAuthInfo() {
        return this.homeKitAuthInfo;
    }

    @Override
    public List<HomekitAccessory> getAccessories() {
        return Optional.ofNullable(this.accessories).orElseGet(() -> {
            this.accessories = new ArrayList<HomekitAccessory>();
            this.addAccessories(this.accessories);
            return this.accessories;
        });
    }

    @Override
    public void addAccessories(List<HomekitAccessory> accessories) {
        this.addDefaultAccessories(accessories);
    }

    @Override
    public void addDefaultAccessories(List<HomekitAccessory> accessories) {
        this.generateDemoAccessoriesWithCondition(accessories);
    }

    @Override
    public void generateBaseScanPackagePathAccessories(List<HomekitAccessory> accessories) {
        Optional.ofNullable(this.homeKitProperties.getBaseScanAccessoriesPackagePath()).ifPresent(paths -> Arrays.stream(paths).forEach(path -> accessories.addAll(HomeKitAccessoryScanner.scanHomeKitAccessoryAndBuildInstance(path))));
    }

    private void generateDemoAccessoriesWithCondition(List<HomekitAccessory> accessories) {
        if (this.homeKitProperties.isAddDemo()) {
            accessories.addAll(HomeKitAccessoryScanner.scanHomeKitAccessoryAndBuildInstance(DEMO_ACCESSORY_PACKAGE_PATH));
        }
    }
}

