/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.service.impl;

import cn.ximcloud.homekit.core.starter.core.auth.XIMCloudHomeKitAuthInfo;
import cn.ximcloud.homekit.core.starter.core.bootstrap.HomeKitBootStrapServer;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitService;
import cn.ximcloud.homekit.core.starter.core.service.WebHomeKitService;
import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryEntity;
import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryMethodEntity;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitAccessoryDetailVo;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitAccessoryMethodVo;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitAccessoryVo;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitQrCodeAndPinCodeVo;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAccessoryMethodRepository;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAccessoryRepository;
import com.google.common.collect.Lists;
import io.github.hapjava.server.impl.crypto.HAPSetupCodeUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class WebHomeKitServiceImpl
implements WebHomeKitService {
    private static final Logger log = LoggerFactory.getLogger(WebHomeKitServiceImpl.class);
    private final HomeKitBootStrapServer homeKitBootStrapServer;
    private final HomeKitAccessoryRepository homeKitAccessoryRepository;
    private final HomeKitAccessoryMethodRepository homeKitAccessoryMethodRepository;
    private final HomeKitService homeKitService;

    public WebHomeKitServiceImpl(HomeKitAccessoryRepository homeKitAccessoryRepository, HomeKitBootStrapServer homeKitBootStrapServer, HomeKitAccessoryMethodRepository homeKitAccessoryMethodRepository, HomeKitService homeKitService) {
        this.homeKitAccessoryRepository = homeKitAccessoryRepository;
        this.homeKitBootStrapServer = homeKitBootStrapServer;
        this.homeKitAccessoryMethodRepository = homeKitAccessoryMethodRepository;
        this.homeKitService = homeKitService;
    }

    @Override
    public List<HomeKitAccessoryVo> getHomeKitList() {
        return Lists.newArrayList((Iterable)this.homeKitAccessoryRepository.findAll()).stream().map(item -> {
            HomeKitAccessoryVo homeKitAccessoryVo = new HomeKitAccessoryVo();
            BeanUtils.copyProperties((Object)item, (Object)homeKitAccessoryVo);
            homeKitAccessoryVo.setClazz(item.getClazz().getName());
            homeKitAccessoryVo.setType(item.getType().toString());
            return homeKitAccessoryVo;
        }).collect(Collectors.toList());
    }

    @Override
    public HomeKitAccessoryVo getHomeKit(Integer id) {
        HomeKitAccessoryVo homeKitAccessoryVo = new HomeKitAccessoryVo();
        HomeKitAccessoryEntity homeKitAccessoryEntity = this.homeKitAccessoryRepository.findById(id).orElse(null);
        if (homeKitAccessoryEntity == null) {
            homeKitAccessoryVo.setId(-1);
            return homeKitAccessoryVo;
        }
        BeanUtils.copyProperties((Object)homeKitAccessoryEntity, (Object)homeKitAccessoryVo);
        return homeKitAccessoryVo;
    }

    @Override
    public Object homeKitSwitch(boolean flag) {
        if (this.homeKitBootStrapServer.isRunning()) {
            if (flag) {
                log.info("homeKit server is running,No need to run again");
            } else {
                this.homeKitBootStrapServer.stopServer();
            }
        } else if (flag) {
            this.homeKitBootStrapServer.startServer();
        } else {
            log.info("homeKit server is not running,No need to stop again");
        }
        return "OK";
    }

    @Override
    public List<HomeKitAccessoryDetailVo> getCurrentReloadedHomeKitAccessories() {
        return this.homeKitBootStrapServer.getCurrentRunningHomeKitAccessories().stream().map(accessory -> {
            HomeKitAccessoryDetailVo.HomeKitAccessoryDetailVoBuilder builder = HomeKitAccessoryDetailVo.builder().id(accessory.getId());
            try {
                builder.name((String)accessory.getName().get());
                builder.serialNumber((String)accessory.getSerialNumber().get());
                builder.model((String)accessory.getModel().get());
                builder.manufacturer((String)accessory.getManufacturer().get());
                builder.firmwareRevision((String)accessory.getFirmwareRevision().get());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("can read accessory value", e);
            }
            return builder.build();
        }).collect(Collectors.toList());
    }

    @Override
    public Object getHomeKitMethod(Integer id, boolean isDefault) {
        return this.homeKitAccessoryMethodRepository.findAllByHomeKitAccessory_Id(id).stream().map(item -> {
            HomeKitAccessoryMethodVo homeKitAccessoryMethodVo = new HomeKitAccessoryMethodVo();
            BeanUtils.copyProperties((Object)item, (Object)homeKitAccessoryMethodVo);
            return homeKitAccessoryMethodVo;
        }).collect(Collectors.toList());
    }

    @Override
    public Object getHomeKitMethod(Integer homeKitId, Integer homeKitMethodId, Boolean isDefault) {
        HomeKitAccessoryMethodEntity homeKitAccessoryMethodEntity = this.homeKitAccessoryMethodRepository.findOneByHomeKitAccessory_IdAndId(homeKitId, homeKitMethodId).orElse(HomeKitAccessoryMethodEntity.builder().id(-1).build());
        HomeKitAccessoryMethodVo homeKitAccessoryMethodVo = new HomeKitAccessoryMethodVo();
        BeanUtils.copyProperties((Object)homeKitAccessoryMethodEntity, (Object)homeKitAccessoryMethodVo);
        return homeKitAccessoryMethodVo;
    }

    @Override
    public HomeKitQrCodeAndPinCodeVo getQrCodeAndPinCode() {
        HomeKitQrCodeAndPinCodeVo homeKitQrCodeAndPinCodeVo = new HomeKitQrCodeAndPinCodeVo();
        XIMCloudHomeKitAuthInfo authInfo = this.homeKitService.getAuthInfo();
        String pin = authInfo.getPin();
        homeKitQrCodeAndPinCodeVo.setQrCode(HAPSetupCodeUtils.getSetupURI((String)pin.replace("-", ""), (String)authInfo.getSetupId(), (int)2));
        homeKitQrCodeAndPinCodeVo.setPinCode(pin);
        return homeKitQrCodeAndPinCodeVo;
    }
}

