/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import io.github.hapjava.server.HomekitAuthInfo;
import io.github.hapjava.server.impl.crypto.HAPSetupCodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrToConsole {
    private static final Logger log = LoggerFactory.getLogger(QrToConsole.class);
    private static final char WHITE_ALL = '\u2588';
    private static final char WHITE_BLACK = '\u2580';
    private static final char BLACK_WHITE = '\u2584';
    private static final char BLACK_ALL = ' ';
    private static final String NEW_LINE = "\r\n";

    private QrToConsole() {
    }

    public static void printQr(HomekitAuthInfo ximCloudHomeKitAuthInfo) {
        String pin = ximCloudHomeKitAuthInfo.getPin();
        String shortPin = pin.replace("-", "");
        String setupId = ximCloudHomeKitAuthInfo.getSetupId();
        String setupUri = HAPSetupCodeUtils.getSetupURI((String)shortPin, (String)setupId, (int)2);
        log.info(QrToConsole.transformQr(setupUri));
        log.info("pin:[{}],setupId:[{}],QR Url:[{}]", new Object[]{pin, setupId, setupUri});
    }

    public static String transformQr(String setupUri) {
        StringBuilder stringBuffer = new StringBuilder(NEW_LINE);
        try {
            BitMatrix matrix = new MultiFormatWriter().encode(setupUri, BarcodeFormat.QR_CODE, 10, 30);
            for (int y = 0; y < matrix.getHeight(); y += 2) {
                for (int x = 0; x < matrix.getWidth(); ++x) {
                    boolean firstRow = matrix.get(x, y);
                    boolean secondRow = matrix.get(x, y + 1);
                    if (firstRow && secondRow) {
                        stringBuffer.append(' ');
                        continue;
                    }
                    if (firstRow) {
                        stringBuffer.append('\u2584');
                        continue;
                    }
                    if (secondRow) {
                        stringBuffer.append('\u2580');
                        continue;
                    }
                    stringBuffer.append('\u2588');
                }
                stringBuffer.append(NEW_LINE);
            }
        }
        catch (WriterException e) {
            log.error("error creating qr code", (Throwable)e);
        }
        return stringBuffer.toString();
    }
}

