/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.accessories;

import cn.ximcloud.homekit.core.starter.constants.PlatformEnum;
import cn.ximcloud.homekit.core.starter.util.PingUtil;
import cn.ximcloud.homekit.core.starter.util.ShutdownUtil;
import io.github.hapjava.accessories.SwitchAccessory;
import io.github.hapjava.accessories.optionalcharacteristic.AccessoryWithHardwareRevision;
import io.github.hapjava.characteristics.HomekitCharacteristicChangeCallback;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WolSwitch
implements SwitchAccessory,
AccessoryWithHardwareRevision {
    private static final Logger log = LoggerFactory.getLogger(WolSwitch.class);
    private String ipAddress;
    private String macAddress;
    private final int id;
    private final PlatformEnum platform;
    private long time = 30L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private HomekitCharacteristicChangeCallback subscribeCallback = null;

    public int getId() {
        return this.id;
    }

    public WolSwitch(int id, String ipAddress, String macAddress) {
        this(id, ipAddress, macAddress, PlatformEnum.WINDOWS);
    }

    public WolSwitch(int id, String ipAddress, String macAddress, PlatformEnum platform) {
        this.id = id;
        this.ipAddress = ipAddress;
        this.macAddress = macAddress;
        this.platform = platform;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public CompletableFuture<String> getName() {
        return CompletableFuture.completedFuture("Computer WOL Switch");
    }

    public void identify() {
        System.out.println("this is a Computer WOL switch accessory");
    }

    public CompletableFuture<String> getSerialNumber() {
        return CompletableFuture.completedFuture("Test SwitchSN");
    }

    public CompletableFuture<String> getModel() {
        return CompletableFuture.completedFuture("TestSwitch Model");
    }

    public CompletableFuture<String> getManufacturer() {
        return CompletableFuture.completedFuture("Test SwitchManufacturer");
    }

    public CompletableFuture<String> getFirmwareRevision() {
        return CompletableFuture.completedFuture("Test Switch Firmware");
    }

    public CompletableFuture<String> getHardwareRevision() {
        return CompletableFuture.completedFuture("Test Switch Hardware");
    }

    public CompletableFuture<Boolean> getSwitchState() {
        return PingUtil.ping(this.ipAddress);
    }

    public CompletableFuture<Void> setSwitchState(boolean state) throws Exception {
        if (this.getSwitchState().join().booleanValue()) {
            if (state) {
                log.debug("the computer is power on now,not need to wol");
            } else {
                ShutdownUtil.shutdown(this.ipAddress, this.platform, this.timeUnit.toSeconds(this.time));
                Optional.ofNullable(this.subscribeCallback).ifPresent(HomekitCharacteristicChangeCallback::changed);
            }
        } else if (state) {
            Optional.ofNullable(this.subscribeCallback).ifPresent(HomekitCharacteristicChangeCallback::changed);
        } else {
            log.debug("the computer is power off now,not need to power off");
        }
        return CompletableFuture.completedFuture(null);
    }

    public void subscribeSwitchState(HomekitCharacteristicChangeCallback callback) {
        this.subscribeCallback = callback;
    }

    public void unsubscribeSwitchState() {
        this.subscribeCallback = null;
    }
}

