/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.accessories.demo;

import cn.ximcloud.homekit.core.enums.InvokeTypeEnum;
import cn.ximcloud.homekit.core.model.ReturnArg;
import cn.ximcloud.homekit.core.starter.entity.HomeKitAccessoryConfigEntity;
import cn.ximcloud.homekit.core.starter.entity.HomeKitAccessoryTypeConfigEntity;
import cn.ximcloud.homekit.core.starter.entity.HomeKitAccessoryTypeEntity;
import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryEntity;
import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryMethodEntity;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAccessoryRepository;
import cn.ximcloud.homekit.core.utils.CommonUtil;
import io.github.hapjava.accessories.FanAccessory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class DemoHomekitAccessoryBuilder {
    private final HomeKitAccessoryRepository homeKitAccessoryRepository;

    public DemoHomekitAccessoryBuilder(HomeKitAccessoryRepository homeKitAccessoryRepository) {
        this.homeKitAccessoryRepository = homeKitAccessoryRepository;
    }

    public HomeKitAccessoryConfigEntity buildDemoHomeKitAccessory() {
        HomeKitAccessoryConfigEntity homeKitAccessoryConfig = new HomeKitAccessoryConfigEntity();
        homeKitAccessoryConfig.setId(0x7FFFFFFC);
        homeKitAccessoryConfig.setName("XIMCloud \u7535\u98ce\u6247");
        homeKitAccessoryConfig.setSerialNumber("0.0.1");
        homeKitAccessoryConfig.setModel("0.0.1");
        homeKitAccessoryConfig.setManufacturer("0.0.1");
        homeKitAccessoryConfig.setFirmwareRevision("0.0.1");
        homeKitAccessoryConfig.setDescription("XIMCloud \u7535\u98ce\u6247");
        ArrayList<HomeKitAccessoryTypeEntity> homeKitAccessoryTypes = new ArrayList<HomeKitAccessoryTypeEntity>();
        HomeKitAccessoryTypeEntity homeKitAccessoryType = new HomeKitAccessoryTypeEntity();
        Optional<HomeKitAccessoryEntity> fanAccessory = this.homeKitAccessoryRepository.findByClazz(FanAccessory.class);
        if (!fanAccessory.isPresent()) {
            throw new IllegalArgumentException("HomeKitAccessoryEntity fanAccessory not found!");
        }
        HomeKitAccessoryEntity homeKitAccessoryEntity = fanAccessory.get();
        homeKitAccessoryType.setTypeClass(homeKitAccessoryEntity);
        ArrayList<HomeKitAccessoryTypeConfigEntity> homeKitAccessoryTypeConfigs = new ArrayList<HomeKitAccessoryTypeConfigEntity>();
        HomeKitAccessoryTypeConfigEntity homeKitAccessoryTypeConfig = new HomeKitAccessoryTypeConfigEntity();
        homeKitAccessoryTypeConfig.setHomeKitAccessoryTypeEntity(homeKitAccessoryType);
        String isActiveMethodName = CommonUtil.generateMethodString((Method)FanAccessory.class.getDeclaredMethod("isActive", new Class[0]));
        Optional<HomeKitAccessoryMethodEntity> methodEntityOptional = homeKitAccessoryEntity.getHomekitAccessoryMethodList().stream().filter(method -> method.getEnhancedMethodName().equals(isActiveMethodName)).findFirst();
        if (!methodEntityOptional.isPresent()) {
            throw new IllegalArgumentException("HomeKitAccessoryMethodEntity not found!");
        }
        homeKitAccessoryTypeConfig.setMethod(methodEntityOptional.get());
        homeKitAccessoryTypeConfig.setInvokeType(InvokeTypeEnum.VALUE);
        ReturnArg returnArg = new ReturnArg();
        returnArg.setArg("true");
        homeKitAccessoryTypeConfig.setReturnArg(returnArg);
        homeKitAccessoryTypeConfig.setInvokeBody(null);
        homeKitAccessoryTypeConfigs.add(homeKitAccessoryTypeConfig);
        homeKitAccessoryTypeConfig = new HomeKitAccessoryTypeConfigEntity();
        homeKitAccessoryTypeConfig.setHomeKitAccessoryTypeEntity(homeKitAccessoryType);
        String setActiveMethodName = CommonUtil.generateMethodString((Method)FanAccessory.class.getDeclaredMethod("setActive", Boolean.TYPE));
        methodEntityOptional = homeKitAccessoryEntity.getHomekitAccessoryMethodList().stream().filter(method -> method.getEnhancedMethodName().equals(setActiveMethodName)).findFirst();
        if (!methodEntityOptional.isPresent()) {
            throw new IllegalArgumentException("HomeKitAccessoryMethodEntity not found!");
        }
        homeKitAccessoryTypeConfig.setMethod(methodEntityOptional.get());
        homeKitAccessoryTypeConfig.setInvokeType(InvokeTypeEnum.NOT_INVOKE);
        homeKitAccessoryTypeConfig.setReturnArg(null);
        homeKitAccessoryTypeConfig.setInvokeBody(null);
        homeKitAccessoryTypeConfigs.add(homeKitAccessoryTypeConfig);
        homeKitAccessoryType.setAccessoryTypeConfig(homeKitAccessoryTypeConfigs);
        homeKitAccessoryType.setHomeKitAccessoryConfigEntity(homeKitAccessoryConfig);
        homeKitAccessoryTypes.add(homeKitAccessoryType);
        homeKitAccessoryConfig.setHomeKitAccessoryTypes(homeKitAccessoryTypes);
        return homeKitAccessoryConfig;
    }
}

