/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.accessories.demo;

import cn.ximcloud.homekit.core.starter.util.annotation.HomeKit;
import io.github.hapjava.accessories.LightbulbAccessory;
import io.github.hapjava.accessories.optionalcharacteristic.AccessoryWithColorTemperature;
import io.github.hapjava.accessories.optionalcharacteristic.AccessoryWithHardwareRevision;
import io.github.hapjava.characteristics.HomekitCharacteristicChangeCallback;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HomeKit
public class DemoLightAccessory
implements LightbulbAccessory,
AccessoryWithHardwareRevision,
AccessoryWithColorTemperature {
    private static final Logger log = LoggerFactory.getLogger(DemoLightAccessory.class);
    private boolean powerState = false;
    private int colorTemperature;
    private HomekitCharacteristicChangeCallback subscribeCallback = null;
    private HomekitCharacteristicChangeCallback colorTemperatureCallback = null;

    public DemoLightAccessory() {
        new Thread(() -> {
            while (true) {
                this.setLightbulbPowerState(new Random().nextInt(2) == 1);
                this.setColorTemperature(new Random().nextInt(100));
                try {
                    TimeUnit.SECONDS.sleep(5L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }).start();
    }

    public int getId() {
        return 0x7FFFFFFE;
    }

    public CompletableFuture<String> getName() {
        return CompletableFuture.completedFuture("Test Switch Name");
    }

    public void identify() {
        log.info("Identifying light");
    }

    public CompletableFuture<String> getSerialNumber() {
        return CompletableFuture.completedFuture("Test SwitchSN");
    }

    public CompletableFuture<String> getModel() {
        return CompletableFuture.completedFuture("TestSwitch Model");
    }

    public CompletableFuture<String> getManufacturer() {
        return CompletableFuture.completedFuture("Test SwitchManufacturer");
    }

    public CompletableFuture<String> getFirmwareRevision() {
        return CompletableFuture.completedFuture("Test Switch Firmware");
    }

    public CompletableFuture<Boolean> getLightbulbPowerState() {
        return CompletableFuture.completedFuture(this.powerState);
    }

    public CompletableFuture<Void> setLightbulbPowerState(boolean powerState) {
        this.powerState = powerState;
        Optional.ofNullable(this.subscribeCallback).ifPresent(HomekitCharacteristicChangeCallback::changed);
        log.info("The demo light accessory is now {}", (Object)(powerState ? "on" : "off"));
        return CompletableFuture.completedFuture(null);
    }

    public void subscribeLightbulbPowerState(HomekitCharacteristicChangeCallback callback) {
        this.subscribeCallback = callback;
    }

    public void unsubscribeLightbulbPowerState() {
        this.subscribeCallback = null;
    }

    public CompletableFuture<String> getHardwareRevision() {
        return CompletableFuture.completedFuture("Test Switch Hardware");
    }

    public CompletableFuture<Integer> getColorTemperature() {
        return CompletableFuture.completedFuture(this.colorTemperature);
    }

    public CompletableFuture<Void> setColorTemperature(Integer value) {
        this.colorTemperature = value;
        log.debug("The demo light accessory color temperature is {}", (Object)value);
        Optional.ofNullable(this.colorTemperatureCallback).ifPresent(HomekitCharacteristicChangeCallback::changed);
        return CompletableFuture.completedFuture(null);
    }

    public void subscribeColorTemperature(HomekitCharacteristicChangeCallback callback) {
        this.colorTemperatureCallback = callback;
    }

    public void unsubscribeColorTemperature() {
        this.colorTemperatureCallback = null;
    }
}

