/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.accessories.demo;

import io.github.hapjava.accessories.LightbulbAccessory;
import io.github.hapjava.accessories.optionalcharacteristic.AccessoryWithHardwareRevision;
import io.github.hapjava.characteristics.HomekitCharacteristicChangeCallback;
import java.util.concurrent.CompletableFuture;

public class MockSwitch
implements LightbulbAccessory,
AccessoryWithHardwareRevision {
    private boolean powerState = false;
    private HomekitCharacteristicChangeCallback subscribeCallback = null;

    public int getId() {
        return 2;
    }

    public CompletableFuture<String> getName() {
        return CompletableFuture.completedFuture("Test Switch Name");
    }

    public void identify() {
        System.out.println("Identifying light");
    }

    public CompletableFuture<String> getSerialNumber() {
        return CompletableFuture.completedFuture("Test SwitchSN");
    }

    public CompletableFuture<String> getModel() {
        return CompletableFuture.completedFuture("TestSwitch Model");
    }

    public CompletableFuture<String> getManufacturer() {
        return CompletableFuture.completedFuture("Test SwitchManufacturer");
    }

    public CompletableFuture<String> getFirmwareRevision() {
        return CompletableFuture.completedFuture("Test Switch Firmware");
    }

    public CompletableFuture<Boolean> getLightbulbPowerState() {
        return CompletableFuture.completedFuture(this.powerState);
    }

    public CompletableFuture<Void> setLightbulbPowerState(boolean powerState) throws Exception {
        this.powerState = powerState;
        if (this.subscribeCallback != null) {
            this.subscribeCallback.changed();
        }
        System.out.println("The lightbulb is now " + (powerState ? "on" : "off"));
        return CompletableFuture.completedFuture(null);
    }

    public void subscribeLightbulbPowerState(HomekitCharacteristicChangeCallback callback) {
        this.subscribeCallback = callback;
    }

    public void unsubscribeLightbulbPowerState() {
        this.subscribeCallback = null;
    }

    public CompletableFuture<String> getHardwareRevision() {
        return CompletableFuture.completedFuture("Test Switch Hardware");
    }
}

