/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.bootstrap;

import cn.ximcloud.homekit.core.starter.autoconfig.HomeKitDataAutoConfiguration;
import cn.ximcloud.homekit.core.starter.autoconfig.HomeKitServiceAutoConfiguration;
import cn.ximcloud.homekit.core.starter.autoconfig.properties.HomeKitProperties;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitService;
import cn.ximcloud.homekit.core.starter.util.QrToConsole;
import com.google.common.collect.Maps;
import io.github.hapjava.accessories.HomekitAccessory;
import io.github.hapjava.server.HomekitAuthInfo;
import io.github.hapjava.server.impl.HomekitRoot;
import io.github.hapjava.server.impl.HomekitServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Service;

@Service
@Configuration
@AutoConfigureAfter(value={HomeKitDataAutoConfiguration.class, HomeKitServiceAutoConfiguration.class})
public class HomeKitBootStrapServer
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(HomeKitBootStrapServer.class);
    private final HomeKitProperties homeKitProperties;
    private final HomeKitService homeKitService;
    private volatile boolean flag = false;
    private HomekitRoot homekitRoot;
    private Map<Integer, HomekitAccessory> accessoryCache;
    private Map<Integer, HomekitAccessory> currentRunningHomeKitAccessoriesCache;
    private static final String UN_SET = "unset";

    public HomeKitBootStrapServer(HomeKitProperties homeKitProperties, HomeKitService homeKitService) {
        this.homeKitProperties = homeKitProperties;
        this.homeKitService = homeKitService;
    }

    public void destroy() {
        this.releaseAllAccessories();
        this.stopServer();
    }

    public void afterPropertiesSet() {
        log.debug("generate HomeKit Server to Stand by");
        this.homekitRoot = new HomekitServer(this.homeKitProperties.getPort().intValue()).createBridge((HomekitAuthInfo)this.homeKitService.getAuthInfo(), this.homeKitProperties.getLabel(), this.homeKitProperties.getManufacturer(), this.homeKitProperties.getModel(), this.homeKitProperties.getSerialNumber(), this.homeKitProperties.getFirmwareRevision(), this.homeKitProperties.getHardwareRevision());
        this.autoScanCheckAndAddAccessories();
        if (this.homeKitProperties.isAutoStart()) {
            log.debug("auto starting homeKit Server");
            this.currentRunningHomeKitAccessoriesCache = Collections.unmodifiableMap(this.accessoryCache);
            this.homekitRoot.start();
            this.flag = true;
            log.debug("homeKit Server is running now");
        }
        QrToConsole.printQr(this.homeKitService.getAuthInfo());
    }

    public boolean isRunning() {
        return this.flag;
    }

    public synchronized void startServer() {
        if (!this.flag) {
            log.debug("starting HomeKit server");
            this.homekitRoot = new HomekitServer(this.homeKitProperties.getPort().intValue()).createBridge((HomekitAuthInfo)this.homeKitService.getAuthInfo(), this.homeKitProperties.getLabel(), this.homeKitProperties.getManufacturer(), this.homeKitProperties.getModel(), this.homeKitProperties.getSerialNumber(), this.homeKitProperties.getFirmwareRevision(), this.homeKitProperties.getHardwareRevision());
            this.currentRunningHomeKitAccessoriesCache.values().forEach(arg_0 -> ((HomekitRoot)this.homekitRoot).addAccessory(arg_0));
            this.currentRunningHomeKitAccessoriesCache.values().forEach(HomeKitBootStrapServer::printAccessoryLog);
            this.homekitRoot.start();
            QrToConsole.printQr(this.homeKitService.getAuthInfo());
            this.flag = true;
            log.debug("HomeKit server started successful");
        } else {
            log.warn("homeKit is running now ,can not restart");
        }
    }

    public synchronized void stopServer() {
        log.debug("stopping HomeKit server");
        this.homekitRoot.stop();
        this.flag = false;
        log.debug("HomeKit server stopped successful now");
    }

    public List<HomekitAccessory> getCurrentLoadedHomeKitAccessories() {
        return Collections.unmodifiableList(new ArrayList<HomekitAccessory>(this.accessoryCache.values()));
    }

    public List<HomekitAccessory> getCurrentRunningHomeKitAccessories() {
        return Collections.unmodifiableList(new ArrayList<HomekitAccessory>(this.currentRunningHomeKitAccessoriesCache.values()));
    }

    private void autoScanCheckAndAddAccessories() {
        List<HomekitAccessory> homekitAccessories = this.homeKitService.getAccessories().stream().sorted(Comparator.comparing(HomekitAccessory::getId)).filter(accessory -> {
            if (accessory.getId() == 1) {
                log.warn("accessory [{}] has a warn id number 1", accessory);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        this.cacheToAccessoryLake(homekitAccessories);
    }

    private static void printAccessoryLog(HomekitAccessory accessory) {
        log.info("add accessory [Id:{},Name:{},SerialNumber:{},Model:{},Manufacturer:{},FirmwareRevision:{}]", new Object[]{accessory.getId(), accessory.getName().join(), Optional.ofNullable(accessory.getSerialNumber()).map(CompletableFuture::join).orElse(UN_SET), Optional.ofNullable(accessory.getModel()).map(CompletableFuture::join).orElse(UN_SET), Optional.ofNullable(accessory.getManufacturer()).map(CompletableFuture::join).orElse(UN_SET), Optional.ofNullable(accessory.getFirmwareRevision()).map(CompletableFuture::join).orElse(UN_SET)});
    }

    private void releaseAllAccessories() {
        this.accessoryCache.values().forEach(accessory -> this.homekitRoot.removeAccessory(accessory));
        this.accessoryCache = Collections.unmodifiableMap(Maps.newHashMap());
        this.currentRunningHomeKitAccessoriesCache = Collections.unmodifiableMap(Maps.newHashMap());
    }

    private void cacheToAccessoryLake(List<HomekitAccessory> homekitAccessories) {
        this.accessoryCache = Collections.unmodifiableMap(homekitAccessories.stream().collect(Collectors.toMap(HomekitAccessory::getId, x -> x)));
        this.accessoryCache.values().forEach(HomeKitBootStrapServer::printAccessoryLog);
        this.accessoryCache.values().forEach(arg_0 -> ((HomekitRoot)this.homekitRoot).addAccessory(arg_0));
    }

    public void startAccessory(Integer id) {
        HomekitAccessory homekitAccessory = this.accessoryCache.get(id);
        this.homekitRoot.addAccessory(homekitAccessory);
        HashMap homekitAccessories = Maps.newHashMap(this.currentRunningHomeKitAccessoriesCache);
        homekitAccessories.put(homekitAccessory.getId(), homekitAccessory);
        this.currentRunningHomeKitAccessoriesCache = Collections.unmodifiableMap(homekitAccessories);
    }

    public void stopAccessory(Integer id) {
        HomekitAccessory homekitAccessory = this.currentRunningHomeKitAccessoriesCache.get(id);
        this.homekitRoot.removeAccessory(homekitAccessory);
        HashMap homekitAccessories = Maps.newHashMap(this.currentRunningHomeKitAccessoriesCache);
        homekitAccessories.remove(homekitAccessory.getId());
        this.currentRunningHomeKitAccessoriesCache = Collections.unmodifiableMap(homekitAccessories);
    }
}

