/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.controller;

import cn.ximcloud.homekit.core.starter.constants.HomeKitAccessoryTypeEnum;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitControlService;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitAccessoryDetailVo;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitAccessoryVo;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitQrCodeAndPinCodeVo;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"homekit"})
public class HomeKitController {
    private final HomeKitControlService homeKitControlService;

    public HomeKitController(HomeKitControlService homeKitControlService) {
        this.homeKitControlService = homeKitControlService;
    }

    @GetMapping(value={"initialization"})
    public ModelAndView initialization(ModelAndView modelAndView) {
        modelAndView.setViewName("initialization");
        return modelAndView;
    }

    @GetMapping(value={"", "index", "dashboard"})
    public ModelAndView index(ModelAndView modelAndView) {
        modelAndView.setViewName("dashboard");
        modelAndView.addObject((Object)this.homeKitControlService.getDashBoardData());
        return modelAndView;
    }

    @GetMapping(value={"accessory"})
    public ModelAndView accessory(ModelAndView modelAndView, HomeKitAccessoryTypeEnum type) {
        modelAndView.setViewName("homekitAccessory");
        modelAndView.addObject("homeKitList", this.homeKitControlService.getHomeKitList(type));
        modelAndView.addObject("searchType", Optional.ofNullable(type).map(Enum::toString).orElse(null));
        return modelAndView;
    }

    @GetMapping(value={"accessory/item"})
    public ModelAndView accessoryItem(ModelAndView modelAndView, String type) {
        modelAndView.setViewName("homekitAccessoryItem");
        modelAndView.addObject("homeKit", this.homeKitControlService.getHomeKitAccessoryList(type));
        modelAndView.addObject("searchType", (Object)type);
        return modelAndView;
    }

    @GetMapping(value={"status"})
    public ModelAndView test(ModelAndView modelAndView) {
        modelAndView.setViewName("status");
        return modelAndView;
    }

    @GetMapping(value={"getQrCodeAndPinCode"})
    public HomeKitQrCodeAndPinCodeVo getQrCodeAndPinCode() {
        return this.homeKitControlService.getQrCodeAndPinCode();
    }

    @GetMapping(value={"homeKitAccessory/{id}"})
    public HomeKitAccessoryVo getHomeKitAccessory(@PathVariable(value="id") Integer id) {
        return this.homeKitControlService.getHomeKitAccessory(id);
    }

    @GetMapping(value={"homeKitMethod/{homeKitId}"})
    public Object getHomeKitMethod(@PathVariable(value="homeKitId") Integer homeKitId, Boolean isDefault) {
        return this.homeKitControlService.getHomeKitMethod(homeKitId, isDefault);
    }

    @GetMapping(value={"homeKitMethod/{homeKitId}/{homeKitMethodId}"})
    public Object getHomeKitMethod(@PathVariable(value="homeKitId") Integer homeKitId, @PathVariable(value="homeKitMethodId") Integer homeKitMethodId, Boolean isDefault) {
        return this.homeKitControlService.getHomeKitMethod(homeKitId, homeKitMethodId, isDefault);
    }

    @GetMapping(value={"switch/{flag}"})
    public boolean homeKitSwitch(@PathVariable(value="flag") boolean flag) {
        return this.homeKitControlService.homeKitSwitch(flag);
    }

    @GetMapping(value={"currentLoadedHomeKitAccessories"})
    public List<HomeKitAccessoryDetailVo> currentLoadedHomeKitAccessories() {
        return this.homeKitControlService.getCurrentLoadedHomeKitAccessories();
    }

    @GetMapping(value={"accessory/{optional}/{id}"})
    public boolean accessoryOption(@PathVariable(value="optional") String optional, @PathVariable(value="id") Integer id) {
        return this.homeKitControlService.accessoryOption("start".equals(optional), id);
    }
}

