/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.service.impl;

import cn.ximcloud.homekit.core.starter.constants.HomeKitAccessoryTypeEnum;
import cn.ximcloud.homekit.core.starter.core.auth.XIMCloudHomeKitAuthInfo;
import cn.ximcloud.homekit.core.starter.core.bootstrap.HomeKitBootStrapServer;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitControlService;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitService;
import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryEntity;
import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryMethodEntity;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitAccessoryDetailVo;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitAccessoryMethodVo;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitAccessoryVo;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitDashBoardVo;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitQrCodeAndPinCodeVo;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAccessoryMethodRepository;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAccessoryRepository;
import com.google.common.collect.Lists;
import io.github.hapjava.accessories.HomekitAccessory;
import io.github.hapjava.server.impl.crypto.HAPSetupCodeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class HomeKitControlServiceImpl
implements HomeKitControlService {
    private static final Logger log = LoggerFactory.getLogger(HomeKitControlServiceImpl.class);
    private final HomeKitBootStrapServer homeKitBootStrapServer;
    private final HomeKitAccessoryRepository homeKitAccessoryRepository;
    private final HomeKitAccessoryMethodRepository homeKitAccessoryMethodRepository;
    private final HomeKitService homeKitService;

    public HomeKitControlServiceImpl(HomeKitAccessoryRepository homeKitAccessoryRepository, HomeKitBootStrapServer homeKitBootStrapServer, HomeKitAccessoryMethodRepository homeKitAccessoryMethodRepository, HomeKitService homeKitService) {
        this.homeKitAccessoryRepository = homeKitAccessoryRepository;
        this.homeKitBootStrapServer = homeKitBootStrapServer;
        this.homeKitAccessoryMethodRepository = homeKitAccessoryMethodRepository;
        this.homeKitService = homeKitService;
    }

    @Override
    public List<HomeKitAccessoryVo> getHomeKitList(HomeKitAccessoryTypeEnum type) {
        return Lists.newArrayList((Iterable)Optional.ofNullable(type).map(typeEnum -> this.homeKitAccessoryRepository.findByType(type)).orElse(this.homeKitAccessoryRepository.findAll())).stream().map(item -> {
            HomeKitAccessoryVo homeKitAccessoryVo = new HomeKitAccessoryVo();
            BeanUtils.copyProperties((Object)item, (Object)homeKitAccessoryVo);
            homeKitAccessoryVo.setClazz(item.getClazz().getName());
            homeKitAccessoryVo.setType(item.getType().toString());
            return homeKitAccessoryVo;
        }).collect(Collectors.toList());
    }

    @Override
    public HomeKitAccessoryVo getHomeKitAccessory(Integer id) {
        HomeKitAccessoryVo homeKitAccessoryVo = new HomeKitAccessoryVo();
        HomeKitAccessoryEntity homeKitAccessoryEntity = this.homeKitAccessoryRepository.findById(id).orElse(null);
        if (homeKitAccessoryEntity == null) {
            homeKitAccessoryVo.setId(-1);
            return homeKitAccessoryVo;
        }
        BeanUtils.copyProperties((Object)homeKitAccessoryEntity, (Object)homeKitAccessoryVo);
        return homeKitAccessoryVo;
    }

    @Override
    public boolean homeKitSwitch(boolean flag) {
        if (this.homeKitBootStrapServer.isRunning()) {
            if (flag) {
                log.info("homeKit server is running,No need to run again");
                return false;
            }
            this.homeKitBootStrapServer.stopServer();
        } else if (flag) {
            this.homeKitBootStrapServer.startServer();
        } else {
            log.info("homeKit server is not running,No need to stop again");
        }
        return true;
    }

    @Override
    public List<HomeKitAccessoryDetailVo> getCurrentLoadedHomeKitAccessories() {
        return this.homeKitBootStrapServer.getCurrentLoadedHomeKitAccessories().stream().map(accessory -> HomeKitAccessoryDetailVo.builder().id(accessory.getId()).name((String)accessory.getName().join()).serialNumber((String)accessory.getSerialNumber().join()).model((String)accessory.getModel().join()).manufacturer((String)accessory.getManufacturer().join()).firmwareRevision((String)accessory.getFirmwareRevision().join()).build()).collect(Collectors.toList());
    }

    @Override
    public Object getHomeKitMethod(Integer id, boolean isDefault) {
        return this.homeKitAccessoryMethodRepository.findAllByHomeKitAccessory_Id(id).stream().map(item -> {
            HomeKitAccessoryMethodVo homeKitAccessoryMethodVo = new HomeKitAccessoryMethodVo();
            BeanUtils.copyProperties((Object)item, (Object)homeKitAccessoryMethodVo);
            return homeKitAccessoryMethodVo;
        }).collect(Collectors.toList());
    }

    @Override
    public Object getHomeKitMethod(Integer homeKitId, Integer homeKitMethodId, Boolean isDefault) {
        HomeKitAccessoryMethodEntity homeKitAccessoryMethodEntity = this.homeKitAccessoryMethodRepository.findOneByHomeKitAccessory_IdAndId(homeKitId, homeKitMethodId).orElse(HomeKitAccessoryMethodEntity.builder().id(-1).build());
        HomeKitAccessoryMethodVo homeKitAccessoryMethodVo = new HomeKitAccessoryMethodVo();
        BeanUtils.copyProperties((Object)homeKitAccessoryMethodEntity, (Object)homeKitAccessoryMethodVo);
        return homeKitAccessoryMethodVo;
    }

    @Override
    public HomeKitQrCodeAndPinCodeVo getQrCodeAndPinCode() {
        HomeKitQrCodeAndPinCodeVo homeKitQrCodeAndPinCodeVo = new HomeKitQrCodeAndPinCodeVo();
        XIMCloudHomeKitAuthInfo authInfo = this.homeKitService.getAuthInfo();
        String pin = authInfo.getPin();
        homeKitQrCodeAndPinCodeVo.setQrCode(HAPSetupCodeUtils.getSetupURI((String)pin.replace("-", ""), (String)authInfo.getSetupId(), (int)2));
        homeKitQrCodeAndPinCodeVo.setPinCode(pin);
        return homeKitQrCodeAndPinCodeVo;
    }

    @Override
    public HomeKitDashBoardVo getDashBoardData() {
        ArrayList homeKitAccessoryMethodEntities = Lists.newArrayList((Iterable)this.homeKitAccessoryRepository.findAll());
        return HomeKitDashBoardVo.builder().supportAccessoryCount(homeKitAccessoryMethodEntities.stream().filter(item -> HomeKitAccessoryTypeEnum.ACCESSORY.equals((Object)item.getType())).count()).supportOptionalCharacteristicCount(homeKitAccessoryMethodEntities.stream().filter(item -> HomeKitAccessoryTypeEnum.OPTIONAL_CHARACTERISTIC.equals((Object)item.getType())).count()).runningAccessoryCount(Long.valueOf(this.homeKitBootStrapServer.getCurrentRunningHomeKitAccessories().size())).accessoryCount(Long.valueOf(this.homeKitBootStrapServer.getCurrentLoadedHomeKitAccessories().size())).userCount(Long.valueOf(this.homeKitService.getAuthInfo().getUserList().size())).build();
    }

    @Override
    public List<HomeKitAccessoryDetailVo> getHomeKitAccessoryList(String type) {
        List<HomekitAccessory> currentRunningHomeKitAccessories = this.homeKitBootStrapServer.getCurrentRunningHomeKitAccessories();
        List runningHomeKitAccessories = currentRunningHomeKitAccessories.stream().map(HomekitAccessory::getId).collect(Collectors.toList());
        return Optional.ofNullable(type).map(statusType -> {
            if ("running".equals(statusType)) {
                return currentRunningHomeKitAccessories;
            }
            return this.homeKitBootStrapServer.getCurrentLoadedHomeKitAccessories().stream().filter(item -> !runningHomeKitAccessories.contains(item.getId())).collect(Collectors.toList());
        }).orElseGet(this.homeKitBootStrapServer::getCurrentLoadedHomeKitAccessories).stream().map(item -> HomeKitAccessoryDetailVo.builder().id(item.getId()).name((String)item.getName().join()).serialNumber((String)item.getSerialNumber().join()).model((String)item.getModel().join()).manufacturer((String)item.getManufacturer().join()).firmwareRevision((String)item.getFirmwareRevision().join()).status(runningHomeKitAccessories.contains(item.getId())).build()).collect(Collectors.toList());
    }

    @Override
    public boolean accessoryOption(boolean optional, Integer id) {
        if (this.homeKitBootStrapServer.isRunning()) {
            List loadedHomeKitAccessoriesId = this.homeKitBootStrapServer.getCurrentLoadedHomeKitAccessories().stream().map(HomekitAccessory::getId).collect(Collectors.toList());
            if (loadedHomeKitAccessoriesId.contains(id)) {
                List currentRunningHomeKitAccessoriesId = this.homeKitBootStrapServer.getCurrentRunningHomeKitAccessories().stream().map(HomekitAccessory::getId).collect(Collectors.toList());
                if (optional) {
                    if (currentRunningHomeKitAccessoriesId.contains(id)) {
                        return false;
                    }
                    this.homeKitBootStrapServer.startAccessory(id);
                    return true;
                }
                if (currentRunningHomeKitAccessoriesId.contains(id)) {
                    this.homeKitBootStrapServer.stopAccessory(id);
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }
}

