/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.util;

import cn.ximcloud.homekit.core.starter.constants.PlatformEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownUtil {
    private static final Logger log = LoggerFactory.getLogger(ShutdownUtil.class);
    private static final String windowsPlatform = "shutdown \u2013s \u2013t %d \u2013m %s \u2013c \"shutdown now\" -f";

    private ShutdownUtil() {
    }

    public static void shutdown(String ipAddress, PlatformEnum platform, long time) {
        switch (platform) {
            case LINUX: {
                throw new RuntimeException();
            }
            case WINDOWS: {
                String command = String.format(windowsPlatform, time, ipAddress);
                log.debug("command :{}", (Object)command);
                Process exec = Runtime.getRuntime().exec(command);
                System.out.println(exec.exitValue());
                break;
            }
            case MACOS: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

