package cn.ximcloud.homekit.core.starter.autoconfig;

import cn.ximcloud.homekit.core.starter.core.controller.HomeKitController;
import cn.ximcloud.homekit.core.starter.core.controller.HomeKitUserController;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitUserService;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitControlService;
import lombok.extern.slf4j.Slf4j;
import org.h2.server.web.WebServlet;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.h2.H2ConsoleProperties;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

/**
 * HomeKitWebAdapter
 */
@Slf4j
@ConditionalOnClass({WebServlet.class})
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties({H2ConsoleProperties.class})
@ComponentScan({"cn.ximcloud.homekit.core.starter.core.service"})
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@AutoConfigureAfter({DataSourceAutoConfiguration.class, HomeKitServiceAutoConfiguration.class})
@ConditionalOnProperty(prefix = "ximcloud.homekit", name = "enableHomeKitWebSite", havingValue = "true", matchIfMissing = true)
public class HomeKitWebAutoConfiguration {

    static {
        log.info("init homekit web service auto configuration");
    }

    private final HomeKitControlService homeKitControlService;

    private final HomeKitUserService homeKitUserService;

    public HomeKitWebAutoConfiguration(HomeKitControlService homeKitControlService,
                                       HomeKitUserService homeKitUserService) {
        this.homeKitControlService = homeKitControlService;
        this.homeKitUserService = homeKitUserService;
    }

    @Bean
    public HomeKitController homeKitController() {
        return new HomeKitController(homeKitControlService);
    }

    @Bean
    public HomeKitUserController homeKitUserController() {
        return new HomeKitUserController(homeKitUserService);
    }


}
