package cn.ximcloud.homekit.core.starter.autoconfig.properties;


import cn.ximcloud.homekit.core.starter.constants.DataSourceConstant;
import cn.ximcloud.homekit.core.starter.autoconfig.condition.BaseOnDatabaseHomeKitCondition;
import lombok.Data;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static cn.ximcloud.homekit.core.starter.autoconfig.properties.HomeKitDataSourceProperties.DATA_SOURCE_CONFIG_PREFIX;


@Data
@AutoConfigureBefore(BaseOnDatabaseHomeKitCondition.class)
@ConfigurationProperties(prefix = DATA_SOURCE_CONFIG_PREFIX)
public class HomeKitDataSourceProperties {

    public static final String DATA_SOURCE_CONFIG_PREFIX = "ximcloud.homekit.datasource";

    private DataSourceConstant type = DataSourceConstant.SIMPLE_DEMO;

    private String file;

}
