package cn.ximcloud.homekit.core.starter.core.controller;

import cn.ximcloud.homekit.core.starter.constants.HomeKitAccessoryTypeEnum;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitControlService;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitAccessoryDetailVo;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitAccessoryVo;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitQrCodeAndPinCodeVo;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping("homekit")
public class HomeKitController {

    private final HomeKitControlService homeKitControlService;

    public HomeKitController(HomeKitControlService homeKitControlService) {
        this.homeKitControlService = homeKitControlService;
    }

//    ==========================================page start=======================================================

    /**
     * 初始化页面，当没有配对homekit时，跳转到此页面
     *
     * @return ModelAndView
     */
    @GetMapping("initialization")
    public ModelAndView initialization(ModelAndView modelAndView) {
        modelAndView.setViewName("initialization");
        return modelAndView;
    }

    /**
     * dashboard
     *
     * @return ModelAndView
     */
    @GetMapping({"", "index", "dashboard"})
    public ModelAndView index(ModelAndView modelAndView) {
        modelAndView.setViewName("dashboard");
        modelAndView.addObject(homeKitControlService.getDashBoardData());
        return modelAndView;
    }

    /**
     * 配件和可选特性
     *
     * @return ModelAndView
     */
    @GetMapping({"accessory"})
    public ModelAndView accessory(ModelAndView modelAndView, HomeKitAccessoryTypeEnum type) {
        modelAndView.setViewName("homekitAccessory");
        modelAndView.addObject("homeKitList", homeKitControlService.getHomeKitList(type));
        modelAndView.addObject("searchType", Optional.ofNullable(type).map(Enum::toString).orElse(null));
        return modelAndView;
    }

    /**
     * accessory
     *
     * @return ModelAndView
     */
    @GetMapping({"accessory/item"})
    public ModelAndView accessoryItem(ModelAndView modelAndView, String type) {
        modelAndView.setViewName("homekitAccessoryItem");
        modelAndView.addObject("homeKit", homeKitControlService.getHomeKitAccessoryList(type));
        modelAndView.addObject("searchType", type);
        return modelAndView;
    }

    /**
     * status
     *
     * @return ModelAndView
     */
    @GetMapping("status")
    public ModelAndView test(ModelAndView modelAndView) {
        modelAndView.setViewName("status");
        return modelAndView;
    }

//    ==========================================page end=======================================================

    @GetMapping("getQrCodeAndPinCode")
    public HomeKitQrCodeAndPinCodeVo getQrCodeAndPinCode() {
        return homeKitControlService.getQrCodeAndPinCode();
    }

//    /**
//     * 获取配件信息列表
//     *
//     * @return 配件信息列表
//     */
//    @GetMapping("homeKitList")
//    public List<HomeKitAccessoryVo> getHomeKitList() {
//        return webHomeKitService.getHomeKitList(type);
//    }

    /**
     * 获取指定的配件信息
     *
     * @param id 配件id
     * @return 指定的配件信息
     */
    @GetMapping("homeKitAccessory/{id}")
    public HomeKitAccessoryVo getHomeKitAccessory(@PathVariable("id") Integer id) {
        return homeKitControlService.getHomeKitAccessory(id);
    }

    /**
     * 获取指定配件下的方法信息列表
     *
     * @param homeKitId 配件id
     * @param isDefault 是否为默认方法
     * @return Object
     */
    @GetMapping("homeKitMethod/{homeKitId}")
    public Object getHomeKitMethod(@PathVariable("homeKitId") Integer homeKitId, Boolean isDefault) {
        return homeKitControlService.getHomeKitMethod(homeKitId, isDefault);
    }

    @GetMapping("homeKitMethod/{homeKitId}/{homeKitMethodId}")
    public Object getHomeKitMethod(@PathVariable("homeKitId") Integer homeKitId,
                                   @PathVariable("homeKitMethodId") Integer homeKitMethodId,
                                   Boolean isDefault) {
        return homeKitControlService.getHomeKitMethod(homeKitId, homeKitMethodId, isDefault);
    }

    /**
     * 启停homekit server
     *
     * @param flag true & false
     * @return 启停状态
     */
    @GetMapping("switch/{flag}")
    public boolean homeKitSwitch(@PathVariable("flag") boolean flag) {
        return homeKitControlService.homeKitSwitch(flag);
    }

    /**
     * 获取当前加载的配件信息
     *
     * @return List<HomeKitAccessoryDetailVo>
     */
    @GetMapping("currentLoadedHomeKitAccessories")
    public List<HomeKitAccessoryDetailVo> currentLoadedHomeKitAccessories() {
        return homeKitControlService.getCurrentLoadedHomeKitAccessories();
    }

    @GetMapping("accessory/{optional}/{id}")
    public boolean accessoryOption(@PathVariable("optional") String optional, @PathVariable("id") Integer id) {
        return homeKitControlService.accessoryOption("start".equals(optional), id);
    }
}
