package cn.ximcloud.homekit.core.starter.core.controller;

import cn.ximcloud.homekit.core.starter.core.service.HomeKitUserService;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitUserVo;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("homekit/user")
public class HomeKitUserController {

    private final HomeKitUserService homeKitUserService;

    public HomeKitUserController(HomeKitUserService homeKitUserService) {
        this.homeKitUserService = homeKitUserService;
    }

    /**
     * 判断是否存在用户
     *
     * @return boolean
     */
    @GetMapping("has")
    public boolean hasUser() {
        return homeKitUserService.hasUser();
    }

    @GetMapping("has/{userName}")
    public boolean hasUser(@PathVariable("userName") String userName) {
        return homeKitUserService.hasUser(userName);
    }

    @GetMapping("list")
    public List<HomeKitUserVo> userList() {
        return homeKitUserService.getUserList();
    }

    @GetMapping("delete")
    public boolean deleteUser(String userName) {
        return homeKitUserService.deleteUser(userName);
    }
}
