package cn.ximcloud.homekit.core.starter.entity;

import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.stereotype.Indexed;

import javax.persistence.*;
import java.io.Serializable;

@Data
@NoArgsConstructor
@Entity(name = "ximcloud_homekit_user")
public class HomeKitUserEntity implements Serializable {

    @Id
    @GeneratedValue(strategy= GenerationType.IDENTITY)
    private Integer id;

    @Column(unique = true)
    private String userName;

    private byte[] publicKey;

    public HomeKitUserEntity(String username, byte[] publicKey) {
        this.userName = username;
        this.publicKey = publicKey;
    }
}
