package cn.ximcloud.homekit.core.starter.repository;

import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryMethodEntity;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

@Repository
public interface HomeKitAccessoryMethodRepository extends CrudRepository<HomeKitAccessoryMethodEntity, Integer> {

    Optional<HomeKitAccessoryMethodEntity> findOneByMethodName(String methodName);

    Optional<HomeKitAccessoryMethodEntity> findOneByEnhancedMethodName(String enhancedMethodName);

    List<HomeKitAccessoryMethodEntity> findAllByHomeKitAccessory_Id(Integer homeKitAccessoryId);


    Optional<HomeKitAccessoryMethodEntity> findOneByHomeKitAccessory_IdAndId(Integer homeKitAccessoryId, Integer homeKitAccessoryMethodId);

}
