package cn.ximcloud.homekit.core.starter.autoconfig;

import cn.ximcloud.homekit.core.starter.autoconfig.properties.HomeKitDataSourceProperties;
import cn.ximcloud.homekit.core.starter.autoconfig.properties.HomeKitProperties;
import cn.ximcloud.homekit.core.starter.autoconfig.condition.BaseOnDatabaseHomeKitCondition;
import cn.ximcloud.homekit.core.starter.autoconfig.condition.EmbeddedDataBaseCondition;
import cn.ximcloud.homekit.core.starter.autoconfig.condition.SimpleDemoHomeKitCondition;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitService;
import cn.ximcloud.homekit.core.starter.core.service.impl.BaseOnDataBaseHomeKitServiceImpl;
import cn.ximcloud.homekit.core.starter.core.service.impl.SimpleDemoHomeKitServiceImpl;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAccessoryConfigRepository;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAccessoryRepository;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAuthInfoRepository;
import cn.ximcloud.homekit.core.starter.repository.HomeKitUserRepository;
import cn.ximcloud.homekit.core.starter.core.accessories.demo.DemoHomekitAccessoryBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

import javax.sql.DataSource;

@Slf4j
@Component
@Configuration
@AutoConfigureBefore(DataSource.class)
@ComponentScan({
        "cn.ximcloud.homekit.core.starter.core.accessories.demo",
        "cn.ximcloud.homekit.core.starter.repository"
})
public class HomeKitServiceAutoConfiguration {

    static {
        log.info("init homekit service auto configuration");
    }

    private final HomeKitAuthInfoRepository homeKitAuthInfoRepository;

    private final HomeKitUserRepository homeKitUserRepository;

    private final HomeKitProperties homeKitProperties;

    private final HomeKitAccessoryConfigRepository homeKitAccessoryConfigRepository;

    private final HomeKitDataSourceProperties homeKitDataSourceProperties;

    private final HomeKitAccessoryRepository homeKitAccessoryRepository;

    private final DemoHomekitAccessoryBuilder demoHomekitAccessoryBuilder;

    public HomeKitServiceAutoConfiguration(HomeKitAuthInfoRepository homeKitAuthInfoRepository,
                                           HomeKitUserRepository homeKitUserRepository,
                                           HomeKitProperties homeKitProperties,
                                           HomeKitAccessoryConfigRepository homeKitAccessoryConfigRepository,
                                           HomeKitDataSourceProperties homeKitDataSourceProperties,
                                           HomeKitAccessoryRepository homeKitAccessoryRepository,
                                           DemoHomekitAccessoryBuilder demoHomekitAccessoryBuilder) {
        this.homeKitAuthInfoRepository = homeKitAuthInfoRepository;
        this.homeKitUserRepository = homeKitUserRepository;
        this.homeKitProperties = homeKitProperties;
        this.homeKitAccessoryConfigRepository = homeKitAccessoryConfigRepository;
        this.homeKitDataSourceProperties = homeKitDataSourceProperties;
        this.homeKitAccessoryRepository = homeKitAccessoryRepository;
        this.demoHomekitAccessoryBuilder = demoHomekitAccessoryBuilder;
    }


    /**
     * 如果未配置
     * @return
     */
    @Bean
    @Conditional(SimpleDemoHomeKitCondition.class)
    public HomeKitService generateSimpleDemoHomeKitServiceWithCondition() {
        log.info("using simple demo homekit service");
        return new SimpleDemoHomeKitServiceImpl(homeKitProperties);
    }

    @Bean
    @Conditional(EmbeddedDataBaseCondition.class)
    public HomeKitService generateEmbeddedDataBaseHomeKitServiceWithCondition() {
        log.info("using base on database homekit service");
        return new BaseOnDataBaseHomeKitServiceImpl(
                homeKitAuthInfoRepository,
                homeKitUserRepository,
                homeKitProperties,
                homeKitAccessoryConfigRepository,
                homeKitDataSourceProperties,
                homeKitAccessoryRepository,
                demoHomekitAccessoryBuilder
        );
    }

    @Bean
    @Conditional(BaseOnDatabaseHomeKitCondition.class)
    public HomeKitService generateDataBaseHomeKitServiceWithCondition() {
        log.info("using base on database homekit service");
        return new BaseOnDataBaseHomeKitServiceImpl(
                homeKitAuthInfoRepository,
                homeKitUserRepository,
                homeKitProperties,
                homeKitAccessoryConfigRepository,
                homeKitDataSourceProperties,
                homeKitAccessoryRepository,
                demoHomekitAccessoryBuilder
        );
    }
}
