package cn.ximcloud.homekit.core.starter.core.controller;

import cn.ximcloud.homekit.core.starter.core.service.HomeKitUserService;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitUserVo;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

import java.util.List;

@RestController
@RequestMapping("homekit/user")
public class HomeKitUserController {

    private final HomeKitUserService homeKitUserService;

    public HomeKitUserController(HomeKitUserService homeKitUserService) {
        this.homeKitUserService = homeKitUserService;
    }
//    ==========================================page start=======================================================


    /**
     * dashboard
     *
     * @return ModelAndView
     */
    @GetMapping
    public ModelAndView index(ModelAndView modelAndView) {
        modelAndView.setViewName("homekitUser");
        modelAndView.addObject("homekitUser", homeKitUserService.getUserList());
        return modelAndView;
    }


//    ==========================================page end=========================================================

    /**
     * 判断是否存在用户
     *
     * @return boolean
     */
    @GetMapping("has")
    public boolean hasUser() {
        return homeKitUserService.hasUser();
    }

    /**
     * 判断该用户是都存在
     *
     * @param userName 用户名
     * @return boolean
     */
    @GetMapping("has/{userName}")
    public boolean hasUser(@PathVariable("userName") String userName) {
        return homeKitUserService.hasUser(userName);
    }

    /**
     * 用户列表
     *
     * @return List<HomeKitUserVo>
     */
    @GetMapping("list")
    public List<HomeKitUserVo> userList() {
        return homeKitUserService.getUserList();
    }

    /**
     * 删除用户
     *
     * @param userName 用户名
     * @return boolean
     */
    @GetMapping("delete/{userName}")
    public boolean deleteUser(@PathVariable("userName") String userName) {
        return homeKitUserService.deleteUser(userName);
    }
}
