package cn.ximcloud.homekit.core.starter.core.service.impl;

import cn.ximcloud.homekit.core.starter.core.bootstrap.HomeKitBootStrapServer;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitService;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitUserService;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitUserVo;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class HomeKitUserServiceImpl implements HomeKitUserService {

    private final HomeKitService homeKitService;

    private final HomeKitBootStrapServer homeKitBootStrapServer;

    public HomeKitUserServiceImpl(HomeKitService homeKitService,
                                  HomeKitBootStrapServer homeKitBootStrapServer) {
        this.homeKitService = homeKitService;
        this.homeKitBootStrapServer = homeKitBootStrapServer;
    }


    @Override
    public boolean hasUser() {
        return homeKitService.getAuthInfo().hasUser();
    }

    @Override
    public List<HomeKitUserVo> getUserList() {
        return homeKitService.getAuthInfo().getUserList();
    }

    @Override
    public boolean deleteUser(String userName) {
        if (hasUser(userName)) {
            homeKitService.getAuthInfo().removeUser(userName);
            if (!hasUser()) {
//                just set Discoverable true
                homeKitBootStrapServer.refreshAuthInfo();
            }
            return true;
        } else {
            return false;
        }
    }

    @Override
    public boolean hasUser(String userName) {
        return homeKitService.getAuthInfo().hasUser(userName);
    }
}
