package cn.ximcloud.homekit.core.starter.core.service.impl;

import cn.ximcloud.homekit.core.starter.autoconfig.properties.HomeKitProperties;
import cn.ximcloud.homekit.core.starter.core.auth.impl.SimpleDemoHomeKitAuthInfoImpl;
import cn.ximcloud.homekit.core.starter.core.auth.XIMCloudHomeKitAuthInfo;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitService;
import cn.ximcloud.homekit.core.starter.util.homekit.HomeKitAccessoryScanner;
import io.github.hapjava.accessories.HomekitAccessory;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;


@Slf4j
public class SimpleDemoHomeKitServiceImpl implements HomeKitService {

    protected static final String DEMO_ACCESSORY_PACKAGE_PATH = "cn.ximcloud.homekit.core.starter.core.accessories";

    private final HomeKitProperties homeKitProperties;

    private final XIMCloudHomeKitAuthInfo homeKitAuthInfo = new SimpleDemoHomeKitAuthInfoImpl();

    private List<HomekitAccessory> accessories;

    public SimpleDemoHomeKitServiceImpl(HomeKitProperties homeKitProperties) {
        this.homeKitProperties = homeKitProperties;
    }

    /**
     * 获取HomeKit 配置
     *
     * @return MockAuthInfo
     */
    @SneakyThrows
    @Override
    public XIMCloudHomeKitAuthInfo getAuthInfo() {
        return homeKitAuthInfo;
    }

    /**
     * 设备列表
     *
     * @return List<HomeKitAccessory>
     */
    @Override
    public List<HomekitAccessory> getAccessories() {
        return Optional.ofNullable(accessories).orElseGet(() -> {
            accessories = new ArrayList<>();
            addAccessories(accessories);
            return accessories;
        });
    }

    @Override
    public void addAccessories(List<HomekitAccessory> accessories) {
        addDefaultAccessories(accessories);
    }

    @Override
    public void addDefaultAccessories(List<HomekitAccessory> accessories) {
//        添加demo配件
        generateDemoAccessoriesWithCondition(accessories);

//        包扫描路径的配件
        generateBaseScanPackagePathAccessories(accessories);
    }

    @Override
    public void generateBaseScanPackagePathAccessories(List<HomekitAccessory> accessories) {
        Optional.ofNullable(homeKitProperties.getBaseScanAccessoriesPackagePath())
                .ifPresent(paths -> Arrays.stream(paths).forEach(path -> accessories.addAll(HomeKitAccessoryScanner.scanHomeKitAccessoryAndBuildInstance(path))));
    }

    /**
     * 添加demo配件
     *
     * @param accessories accessories
     */
    private void generateDemoAccessoriesWithCondition(List<HomekitAccessory> accessories) {
        if (homeKitProperties.isAddDemo()) {
            log.debug("generate and add demo accessories");
            accessories.addAll(HomeKitAccessoryScanner.scanHomeKitAccessoryAndBuildInstance(DEMO_ACCESSORY_PACKAGE_PATH));
        }
    }

}
