package cn.ximcloud.homekit.core.starter.entity.metadata;

import cn.ximcloud.homekit.core.starter.constants.HomeKitAccessoryTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

import javax.persistence.*;
import java.io.Serializable;
import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Entity(name = "ximcloud_homekit_accessory")
public class HomeKitAccessoryEntity implements Serializable {

    /**
     * 主键ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Integer id;

    /**
     * 类名
     */
    @Column(unique = true)
    private Class<?> clazz;

    /**
     * HomeKitAccessory 类型(配件&可选特性)
     */
    private HomeKitAccessoryTypeEnum type;

    /**
     * 方法
     * BUG FIX: https://blog.csdn.net/sinat_33201781/article/details/90371989
     */
    @Fetch(FetchMode.SUBSELECT)
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "homeKitAccessory", fetch = FetchType.EAGER)
    private List<HomeKitAccessoryMethodEntity> homekitAccessoryMethodList;

}
