package cn.ximcloud.homekit.core.starter.entity.metadata;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.io.Serializable;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Entity(name = "ximcloud_homekit_accessory_method")
public class HomeKitAccessoryMethodEntity implements Serializable {

    /**
     * 主键ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Integer id;

    /**
     * 方法名
     */
    private String methodName;

    /**
     * 增强的方法名
     */
    private String enhancedMethodName;

    /**
     * 是否为默认方法
     */
    private boolean isDefault;

    /**
     * 多对一 配件entity
     */
    @ManyToOne(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
    private HomeKitAccessoryEntity homeKitAccessory;

}
