package cn.ximcloud.homekit.core.starter.util.wol;

import cn.ximcloud.homekit.core.starter.constants.PlatformEnum;
import cn.ximcloud.homekit.core.starter.util.wol.WOLNode;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ShutdownAndWakeUpUtil {

    private static final String windowsPlatform = "shutdown –s –t %d –m %s –c \"shutdown now\" -f";

    private ShutdownAndWakeUpUtil() {
    }

    @SneakyThrows
    public static void shutdown(String macAddress, String ipAddress, PlatformEnum platform, long time, int retry) {
        switch (platform) {
            case LINUX:
                throw new UnsupportedOperationException();
            case WINDOWS:
                String command = String.format(windowsPlatform, time, ipAddress);
                log.debug("command :{}", command);
                Process exec = Runtime.getRuntime().exec(command);
                System.out.println(exec.exitValue());
                break;
            case MACOS:
                break;
            default:
                throw new UnsupportedOperationException();
        }
    }

    public static void powerOn(String macAddress, String ipAddress, long timeOut, long retry, String broadcastIp, int broadcastPort) {
        new WOLNode(macAddress, broadcastIp, broadcastPort).wakeUP();
    }
}
