/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.autoconfig;

import cn.ximcloud.homekit.core.starter.autoconfig.HomeKitServiceAutoConfiguration;
import cn.ximcloud.homekit.core.starter.core.controller.HomeKitController;
import cn.ximcloud.homekit.core.starter.core.controller.HomeKitUserController;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitControlService;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitUserService;
import org.h2.server.web.WebServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.h2.H2ConsoleProperties;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@ConditionalOnClass(value={WebServlet.class})
@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={H2ConsoleProperties.class})
@ComponentScan(value={"cn.ximcloud.homekit.core.starter.core.service"})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, HomeKitServiceAutoConfiguration.class})
@ConditionalOnProperty(prefix="ximcloud.homekit", name={"enableHomeKitWebSite"}, havingValue="true", matchIfMissing=true)
public class HomeKitWebAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(HomeKitWebAutoConfiguration.class);
    private final HomeKitControlService homeKitControlService;
    private final HomeKitUserService homeKitUserService;

    public HomeKitWebAutoConfiguration(HomeKitControlService homeKitControlService, HomeKitUserService homeKitUserService) {
        this.homeKitControlService = homeKitControlService;
        this.homeKitUserService = homeKitUserService;
    }

    @Bean
    public HomeKitController homeKitController() {
        return new HomeKitController(this.homeKitControlService);
    }

    @Bean
    public HomeKitUserController homeKitUserController() {
        return new HomeKitUserController(this.homeKitUserService);
    }

    static {
        log.info("init homekit web service auto configuration");
    }
}

