/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.accessories;

import cn.ximcloud.homekit.core.starter.constants.PlatformEnum;
import cn.ximcloud.homekit.core.starter.util.wol.PingUtil;
import cn.ximcloud.homekit.core.starter.util.wol.ShutdownAndWakeUpUtil;
import cn.ximcloud.homekit.core.starter.util.wol.validator.MacAddressValidator;
import io.github.hapjava.accessories.SwitchAccessory;
import io.github.hapjava.accessories.optionalcharacteristic.AccessoryWithHardwareRevision;
import io.github.hapjava.characteristics.HomekitCharacteristicChangeCallback;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WolSwitch
implements SwitchAccessory,
AccessoryWithHardwareRevision,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(WolSwitch.class);
    private String ipAddress;
    private String macAddress;
    private final int id;
    private final PlatformEnum platform;
    private long timeOut;
    private TimeUnit timeUnit;
    private HomekitCharacteristicChangeCallback subscribeCallback;
    private int retry;
    private String broadcastIp;
    private int broadcastPort;

    public int getId() {
        return this.id;
    }

    public WolSwitch(int id, String ipAddress, String macAddress) {
        this(id, ipAddress, macAddress, PlatformEnum.WINDOWS);
    }

    public WolSwitch(int id, String ipAddress, String macAddress, PlatformEnum platform) {
        this(id, ipAddress, macAddress, platform, TimeUnit.SECONDS, 30L);
    }

    public WolSwitch(int id, String ipAddress, String macAddress, PlatformEnum platform, TimeUnit timeUnit, long timeOut) {
        this(id, ipAddress, macAddress, platform, timeUnit, timeOut, 3);
    }

    public WolSwitch(int id, String ipAddress, String macAddress, PlatformEnum platform, TimeUnit timeUnit, long timeOut, int retry) {
        this(id, ipAddress, macAddress, platform, timeUnit, timeOut, retry, "255.255.255.255", 9);
    }

    public WolSwitch(int id, String ipAddress, String macAddress, PlatformEnum platform, TimeUnit timeUnit, long timeOut, int retry, String broadcastIp, int broadcastPort) {
        this.validate(id, macAddress);
        this.id = id;
        this.ipAddress = ipAddress;
        this.macAddress = macAddress;
        this.platform = platform;
        this.timeUnit = timeUnit;
        this.timeOut = timeOut;
        this.retry = retry;
        this.broadcastIp = broadcastIp;
        this.broadcastPort = broadcastPort;
    }

    private void validate(int id, String macAddress) {
        if (id == 1) {
            throw new IllegalArgumentException("this accessory id can not be 1.");
        }
        if (!MacAddressValidator.validate(macAddress)) {
            throw new IllegalArgumentException("mac address verification failed.");
        }
    }

    public CompletableFuture<String> getName() {
        return CompletableFuture.completedFuture("\u7535\u8111\u8fdc\u7a0b\u5f00\u5173");
    }

    public void identify() {
        log.info("this is a Computer WOL switch accessory");
    }

    public CompletableFuture<String> getSerialNumber() {
        return CompletableFuture.completedFuture("Test SwitchSN");
    }

    public CompletableFuture<String> getModel() {
        return CompletableFuture.completedFuture("Computer WOL Switch");
    }

    public CompletableFuture<String> getManufacturer() {
        return CompletableFuture.completedFuture("XIMCloud Works");
    }

    public CompletableFuture<String> getFirmwareRevision() {
        return CompletableFuture.completedFuture(WolSwitch.class.getPackage().getImplementationVersion());
    }

    public CompletableFuture<String> getHardwareRevision() {
        return CompletableFuture.completedFuture("1.0.0");
    }

    public CompletableFuture<Boolean> getSwitchState() {
        return PingUtil.ping(this.ipAddress);
    }

    public CompletableFuture<Void> setSwitchState(boolean state) throws Exception {
        if (Boolean.TRUE.equals(this.getSwitchState().join())) {
            if (state) {
                log.warn("the computer is power on now,not need to wol");
            } else {
                ShutdownAndWakeUpUtil.shutdown(this.macAddress, this.ipAddress, this.platform, this.timeUnit.toSeconds(this.timeOut), this.retry);
                Optional.ofNullable(this.subscribeCallback).ifPresent(HomekitCharacteristicChangeCallback::changed);
            }
        } else if (state) {
            ShutdownAndWakeUpUtil.powerOn(this.macAddress, this.ipAddress, this.timeUnit.toSeconds(this.timeOut), this.retry, this.broadcastIp, this.broadcastPort);
            Optional.ofNullable(this.subscribeCallback).ifPresent(HomekitCharacteristicChangeCallback::changed);
        } else {
            log.warn("the computer is power off now,not need to power off");
        }
        return CompletableFuture.completedFuture(null);
    }

    public void subscribeSwitchState(HomekitCharacteristicChangeCallback callback) {
        this.subscribeCallback = callback;
    }

    public void unsubscribeSwitchState() {
        this.subscribeCallback = null;
    }
}

