/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.service.impl;

import cn.ximcloud.homekit.core.starter.autoconfig.properties.HomeKitDataSourceProperties;
import cn.ximcloud.homekit.core.starter.autoconfig.properties.HomeKitProperties;
import cn.ximcloud.homekit.core.starter.constants.HomeKitAccessoryTypeEnum;
import cn.ximcloud.homekit.core.starter.core.accessories.demo.DemoHomekitAccessoryBuilder;
import cn.ximcloud.homekit.core.starter.core.auth.XIMCloudHomeKitAuthInfo;
import cn.ximcloud.homekit.core.starter.core.auth.impl.BaseOnDataBaseHomeKitAuthInfoImpl;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitService;
import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryEntity;
import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryMethodEntity;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAccessoryConfigRepository;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAccessoryRepository;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAuthInfoRepository;
import cn.ximcloud.homekit.core.starter.repository.HomeKitUserRepository;
import cn.ximcloud.homekit.core.starter.util.homekit.HomeKitAccessoryScanner;
import cn.ximcloud.homekit.core.starter.util.homekit.HomekitAccessoryCoverUtil;
import io.github.hapjava.accessories.HomekitAccessory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class BaseOnDataBaseHomeKitServiceImpl
implements HomeKitService {
    private static final Logger log = LoggerFactory.getLogger(BaseOnDataBaseHomeKitServiceImpl.class);
    private final HomeKitAccessoryConfigRepository homeKitAccessoryConfigRepository;
    private final HomeKitProperties homeKitProperties;
    private final HomeKitAuthInfoRepository homeKitAuthInfoRepository;
    private final HomeKitUserRepository homeKitUserRepository;
    private final HomeKitDataSourceProperties homeKitDataSourceProperties;
    private final HomeKitAccessoryRepository homeKitAccessoryRepository;
    private final DemoHomekitAccessoryBuilder demoHomekitAccessoryBuilder;
    private final XIMCloudHomeKitAuthInfo homeKitAuthInfo;
    private List<HomekitAccessory> accessories;

    public BaseOnDataBaseHomeKitServiceImpl(HomeKitAuthInfoRepository homeKitAuthInfoRepository, HomeKitUserRepository homeKitUserRepository, HomeKitProperties homeKitProperties, HomeKitAccessoryConfigRepository homeKitAccessoryConfigRepository, HomeKitDataSourceProperties homeKitDataSourceProperties, HomeKitAccessoryRepository homeKitAccessoryRepository, DemoHomekitAccessoryBuilder demoHomekitAccessoryBuilder) {
        log.info("generate base on database homekit service");
        this.homeKitAuthInfoRepository = homeKitAuthInfoRepository;
        this.homeKitUserRepository = homeKitUserRepository;
        this.homeKitProperties = homeKitProperties;
        this.homeKitAccessoryConfigRepository = homeKitAccessoryConfigRepository;
        this.homeKitDataSourceProperties = homeKitDataSourceProperties;
        this.homeKitAccessoryRepository = homeKitAccessoryRepository;
        this.demoHomekitAccessoryBuilder = demoHomekitAccessoryBuilder;
        this.homeKitAuthInfo = new BaseOnDataBaseHomeKitAuthInfoImpl(homeKitAuthInfoRepository, homeKitUserRepository);
        this.handlerHomeKitAccessoryMetaData();
    }

    @Override
    public XIMCloudHomeKitAuthInfo getAuthInfo() {
        return this.homeKitAuthInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<HomekitAccessory> getAccessories() {
        return Optional.ofNullable(this.accessories).orElseGet(() -> {
            this.accessories = new ArrayList<HomekitAccessory>();
            this.addAccessories(this.accessories);
            return this.accessories;
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addAccessories(List<HomekitAccessory> accessories) {
        this.addDefaultAccessories(accessories);
    }

    @Transactional(rollbackFor={Exception.class})
    public void handlerHomeKitAccessoryMetaData() {
        HomeKitAccessoryScanner.scanHomeKitAccessory().forEach(homeKitAccessoryClass -> this.extracted((Class<?>)homeKitAccessoryClass, HomeKitAccessoryTypeEnum.ACCESSORY));
        HomeKitAccessoryScanner.scanHomeKitAccessoryOptionalCharacteristic().forEach(optionalCharacteristic -> this.extracted((Class<?>)optionalCharacteristic, HomeKitAccessoryTypeEnum.OPTIONAL_CHARACTERISTIC));
    }

    private void extracted(Class<?> homeKitAccessoryClass, HomeKitAccessoryTypeEnum type) {
        if (!this.homeKitAccessoryRepository.findByClazz(homeKitAccessoryClass).isPresent()) {
            HomeKitAccessoryEntity entity = new HomeKitAccessoryEntity();
            entity.setClazz(homeKitAccessoryClass);
            entity.setType(type);
            ArrayList<HomeKitAccessoryMethodEntity> methodList = new ArrayList<HomeKitAccessoryMethodEntity>();
            Set allMethods = ReflectionUtils.getAllMethods(homeKitAccessoryClass, (Predicate[])new Predicate[0]);
            allMethods.forEach(method -> {
                HomeKitAccessoryMethodEntity homeKitAccessoryMethodEntity = HomekitAccessoryCoverUtil.coverToHomeKitAccessoryMethodEntity(method);
                homeKitAccessoryMethodEntity.setHomeKitAccessory(entity);
                methodList.add(homeKitAccessoryMethodEntity);
            });
            entity.setHomekitAccessoryMethodList(methodList);
            this.homeKitAccessoryRepository.save(entity);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addDefaultAccessories(List<HomekitAccessory> accessories) {
        this.generateDemoAccessoriesWithCondition(accessories);
        this.generateFromDataBaseAccessories(accessories);
        this.generateBaseScanPackagePathAccessories(accessories);
    }

    @Override
    public void generateBaseScanPackagePathAccessories(List<HomekitAccessory> accessories) {
        Optional.ofNullable(this.homeKitProperties.getBaseScanAccessoriesPackagePath()).ifPresent(paths -> Arrays.stream(paths).forEach(path -> accessories.addAll(HomeKitAccessoryScanner.scanHomeKitAccessoryAndBuildInstance(path))));
    }

    private void generateDemoAccessoriesWithCondition(List<HomekitAccessory> accessories) {
        if (this.homeKitProperties.isAddDemo()) {
            accessories.addAll(HomeKitAccessoryScanner.scanHomeKitAccessoryAndBuildInstance("cn.ximcloud.homekit.core.starter.core.accessories"));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void generateFromDataBaseAccessories(List<HomekitAccessory> accessories) {
        if (this.homeKitProperties.isAddDemo() && this.homeKitAccessoryConfigRepository.count() == 0L) {
            this.homeKitAccessoryConfigRepository.save(this.demoHomekitAccessoryBuilder.buildDemoHomeKitAccessory());
        }
        this.homeKitAccessoryConfigRepository.findAll().forEach(homeKitAccessoryConfigEntity -> accessories.add(HomekitAccessoryCoverUtil.coverToHomekitAccessory(homeKitAccessoryConfigEntity)));
    }
}

