/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.util.common;

import cn.ximcloud.homekit.core.starter.util.common.EPlatform;

public class OsInfoUtil {
    private static String OS = System.getProperty("os.name").toLowerCase();
    private static OsInfoUtil _instance = new OsInfoUtil();
    private EPlatform platform;

    private OsInfoUtil() {
    }

    public static boolean isLinux() {
        return OS.contains("linux");
    }

    public static boolean isMacOS() {
        return OS.contains("mac") && OS.contains("os") && !OS.contains("x");
    }

    public static boolean isMacOSX() {
        return OS.contains("mac") && OS.contains("os") && OS.contains("x");
    }

    public static boolean isWindows() {
        return OS.contains("windows");
    }

    public static boolean isOS2() {
        return OS.contains("os/2");
    }

    public static boolean isSolaris() {
        return OS.contains("solaris");
    }

    public static boolean isSunOS() {
        return OS.contains("sunos");
    }

    public static boolean isMPEiX() {
        return OS.contains("mpe/ix");
    }

    public static boolean isHPUX() {
        return OS.contains("hp-ux");
    }

    public static boolean isAix() {
        return OS.contains("aix");
    }

    public static boolean isOS390() {
        return OS.contains("os/390");
    }

    public static boolean isFreeBSD() {
        return OS.contains("freebsd");
    }

    public static boolean isIrix() {
        return OS.contains("irix");
    }

    public static boolean isDigitalUnix() {
        return OS.contains("digital") && OS.indexOf("unix") > 0;
    }

    public static boolean isNetWare() {
        return OS.contains("netware");
    }

    public static boolean isOSF1() {
        return OS.contains("osf1");
    }

    public static boolean isOpenVMS() {
        return OS.contains("openvms");
    }

    public static EPlatform getOSname() {
        OsInfoUtil._instance.platform = OsInfoUtil.isAix() ? EPlatform.AIX : (OsInfoUtil.isDigitalUnix() ? EPlatform.Digital_Unix : (OsInfoUtil.isFreeBSD() ? EPlatform.FreeBSD : (OsInfoUtil.isHPUX() ? EPlatform.HP_UX : (OsInfoUtil.isIrix() ? EPlatform.Irix : (OsInfoUtil.isLinux() ? EPlatform.Linux : (OsInfoUtil.isMacOS() ? EPlatform.Mac_OS : (OsInfoUtil.isMacOSX() ? EPlatform.Mac_OS_X : (OsInfoUtil.isMPEiX() ? EPlatform.MPEiX : (OsInfoUtil.isNetWare() ? EPlatform.NetWare_411 : (OsInfoUtil.isOpenVMS() ? EPlatform.OpenVMS : (OsInfoUtil.isOS2() ? EPlatform.OS2 : (OsInfoUtil.isOS390() ? EPlatform.OS390 : (OsInfoUtil.isOSF1() ? EPlatform.OSF1 : (OsInfoUtil.isSolaris() ? EPlatform.Solaris : (OsInfoUtil.isSunOS() ? EPlatform.SunOS : (OsInfoUtil.isWindows() ? EPlatform.Windows : EPlatform.Others))))))))))))))));
        return OsInfoUtil._instance.platform;
    }
}

