/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.util.homekit;

import cn.ximcloud.homekit.core.starter.util.annotation.HomeKit;
import com.google.common.collect.Maps;
import io.github.hapjava.accessories.HomekitAccessory;
import io.github.hapjava.accessories.optionalcharacteristic.AccessoryWithName;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeKitAccessoryScanner {
    private static final Logger log = LoggerFactory.getLogger(HomeKitAccessoryScanner.class);
    private static final String HOMEKIT_ACCESSORY_PACKAGE_PATH = HomekitAccessory.class.getPackage().getName();
    private static final String HOMEKIT_ACCESSORY_OPTIONAL_CHARACTERISTIC_PACKAGE_PATH = AccessoryWithName.class.getPackage().getName();

    private HomeKitAccessoryScanner() {
    }

    public static Set<Class<? extends HomekitAccessory>> scanHomeKitAccessory() {
        return new Reflections(HOMEKIT_ACCESSORY_PACKAGE_PATH, new Scanner[0]).getSubTypesOf(HomekitAccessory.class);
    }

    public static List<Class<?>> scanHomeKitAccessoryOptionalCharacteristic() {
        return new Reflections(new Object[]{HOMEKIT_ACCESSORY_OPTIONAL_CHARACTERISTIC_PACKAGE_PATH, Collections.singletonList(new SubTypesScanner(false))}).getAllTypes().stream().map(x$0 -> ReflectionUtils.forName((String)x$0, (ClassLoader[])new ClassLoader[0])).collect(Collectors.toList());
    }

    public static Collection<? extends HomekitAccessory> scanHomeKitAccessoryAndBuildInstance(String accessoryPackagePath) {
        return HomeKitAccessoryScanner.scanHomeKitAccessoryAndBuildInstance(accessoryPackagePath, true);
    }

    public static Collection<? extends HomekitAccessory> scanHomeKitAccessoryAndBuildInstance(String accessoryPackagePath, boolean isAnnotationBinding) {
        Map methodCollect;
        Reflections reflections = new Reflections(new Object[]{accessoryPackagePath, Arrays.asList(new MethodAnnotationsScanner(), new SubTypesScanner(false))});
        Map classCollect = reflections.getSubTypesOf(HomekitAccessory.class).stream().filter(accessory -> !accessory.isInterface()).filter(accessory -> isAnnotationBinding && accessory.isAnnotationPresent(HomeKit.class)).filter(accessory -> {
            try {
                return Modifier.isPublic(accessory.getDeclaredConstructor(new Class[0]).getModifiers());
            }
            catch (NoSuchMethodException e) {
                log.error("scan accessory error", (Throwable)e);
                return false;
            }
        }).map(accessory -> {
            try {
                return (HomekitAccessory)accessory.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error("scan accessory error", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toConcurrentMap(HomekitAccessory::getId, item -> item));
        try {
            methodCollect = reflections.getMethodsAnnotatedWith(HomeKit.class).stream().filter(method -> HomekitAccessory.class.isAssignableFrom(method.getReturnType())).filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> method.getParameterCount() == 0).map(method -> {
                if (Modifier.isStatic(method.getModifiers())) {
                    try {
                        return (HomekitAccessory)method.invoke(method.getDeclaringClass(), new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        log.error("generate homekit accessory error", (Throwable)e);
                        return null;
                    }
                }
                try {
                    return (HomekitAccessory)method.invoke(method.getDeclaringClass().getConstructor(new Class[0]).newInstance(new Object[0]), new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    log.error("generate homekit accessory error", (Throwable)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toConcurrentMap(HomekitAccessory::getId, item -> item));
        }
        catch (Exception e) {
            log.error("scan accessory within method error,please check method is add @HomeKit or have any method");
            methodCollect = Maps.newHashMap();
        }
        classCollect.putAll(methodCollect);
        return classCollect.values();
    }
}

