/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.util.homekit;

import cn.ximcloud.homekit.core.model.HomeKitAccessoryConfig;
import cn.ximcloud.homekit.core.model.HomeKitAccessoryType;
import cn.ximcloud.homekit.core.model.HomeKitAccessoryTypeConfig;
import cn.ximcloud.homekit.core.proxy.HomeKitAccessoryProxyFactory;
import cn.ximcloud.homekit.core.starter.entity.HomeKitAccessoryConfigEntity;
import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryEntity;
import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryMethodEntity;
import cn.ximcloud.homekit.core.utils.CommonUtil;
import io.github.hapjava.accessories.HomekitAccessory;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.reflections.ReflectionUtils;

public class HomekitAccessoryCoverUtil {
    public static final int ACCESSORY_OFFSET = 1000;

    private HomekitAccessoryCoverUtil() {
    }

    public static HomekitAccessory coverToHomekitAccessory(HomeKitAccessoryConfigEntity homeKitAccessoryConfigEntity) {
        HomeKitAccessoryConfig homeKitAccessoryConfig = new HomeKitAccessoryConfig();
        homeKitAccessoryConfig.setId(1000 + homeKitAccessoryConfigEntity.getId());
        homeKitAccessoryConfig.setName(CompletableFuture.completedFuture(homeKitAccessoryConfigEntity.getName()));
        homeKitAccessoryConfig.setSerialNumber(CompletableFuture.completedFuture(homeKitAccessoryConfigEntity.getSerialNumber()));
        homeKitAccessoryConfig.setModel(CompletableFuture.completedFuture(homeKitAccessoryConfigEntity.getModel()));
        homeKitAccessoryConfig.setManufacturer(CompletableFuture.completedFuture(homeKitAccessoryConfigEntity.getManufacturer()));
        homeKitAccessoryConfig.setFirmwareRevision(CompletableFuture.completedFuture(homeKitAccessoryConfigEntity.getFirmwareRevision()));
        List kitAccessoryTypes = homeKitAccessoryConfigEntity.getHomeKitAccessoryTypes().stream().map(homeKitAccessoryTypeEntity -> {
            HomeKitAccessoryType homeKitAccessoryType = new HomeKitAccessoryType();
            HomeKitAccessoryEntity typeClass = homeKitAccessoryTypeEntity.getTypeClass();
            homeKitAccessoryType.setTypeClass(typeClass.getClazz());
            List homeKitAccessoryTypeConfigs = homeKitAccessoryTypeEntity.getAccessoryTypeConfig().stream().map(homeKitAccessoryTypeConfig -> {
                Method declaredMethod;
                HomeKitAccessoryTypeConfig accessoryTypeConfig = new HomeKitAccessoryTypeConfig();
                HomeKitAccessoryMethodEntity homeKitAccessoryMethod = homeKitAccessoryTypeConfig.getMethod();
                String enhancedMethodName = homeKitAccessoryMethod.getEnhancedMethodName();
                String[] split = enhancedMethodName.split("#");
                Class clazz = ReflectionUtils.forName((String)split[0], (ClassLoader[])new ClassLoader[0]);
                String method = split[1].split("!")[0];
                int start = method.indexOf("[");
                int end = method.indexOf("]");
                String methodName = method.substring(0, start);
                String returnClass = method.substring(start + 1, end);
                try {
                    declaredMethod = Strings.isBlank((String)returnClass) ? clazz.getDeclaredMethod(methodName, new Class[0]) : (!Strings.isBlank((String)returnClass) && returnClass.contains(",") ? clazz.getDeclaredMethod(methodName, (Class[])Arrays.stream(returnClass.split(",")).map(x$0 -> ReflectionUtils.forName((String)x$0, (ClassLoader[])new ClassLoader[0])).toArray(Class[]::new)) : clazz.getDeclaredMethod(methodName, ReflectionUtils.forName((String)returnClass, (ClassLoader[])new ClassLoader[0])));
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("method not found:".concat(methodName));
                }
                accessoryTypeConfig.setMethod(declaredMethod);
                accessoryTypeConfig.setInvokeType(homeKitAccessoryTypeConfig.getInvokeType());
                accessoryTypeConfig.setReturnArg(homeKitAccessoryTypeConfig.getReturnArg());
                accessoryTypeConfig.setInvokeBody(homeKitAccessoryTypeConfig.getInvokeBody());
                return accessoryTypeConfig;
            }).collect(Collectors.toList());
            homeKitAccessoryType.setAccessoryTypeConfig(homeKitAccessoryTypeConfigs);
            return homeKitAccessoryType;
        }).collect(Collectors.toList());
        homeKitAccessoryConfig.setHomeKitAccessoryTypes(kitAccessoryTypes);
        return new HomeKitAccessoryProxyFactory(homeKitAccessoryConfig).newInstance();
    }

    public static HomeKitAccessoryMethodEntity coverToHomeKitAccessoryMethodEntity(Method method) {
        return HomeKitAccessoryMethodEntity.builder().methodName(method.getName()).isDefault(method.isDefault()).enhancedMethodName(CommonUtil.generateMethodString((Method)method)).build();
    }
}

