/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.util.wol;

import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingUtil {
    private static final Logger log = LoggerFactory.getLogger(PingUtil.class);

    private PingUtil() {
    }

    public static CompletableFuture<Boolean> ping(String ipAddress) {
        return PingUtil.ping(ipAddress, 3L, TimeUnit.SECONDS);
    }

    public static CompletableFuture<Boolean> ping(String ipAddress, long timeOut, TimeUnit timeUnit) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return InetAddress.getByName(ipAddress).isReachable((int)timeUnit.toMillis(timeOut));
            }
            catch (IOException e) {
                log.error("ping address {}", (Object)ipAddress);
                return false;
            }
        });
    }
}

