/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.util.wol;

import cn.ximcloud.homekit.core.starter.constants.PlatformEnum;
import cn.ximcloud.homekit.core.starter.util.wol.WOLNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownAndWakeUpUtil {
    private static final Logger log = LoggerFactory.getLogger(ShutdownAndWakeUpUtil.class);
    private static final String windowsPlatform = "shutdown \u2013s \u2013t %d \u2013m %s \u2013c \"shutdown now\" -f";

    private ShutdownAndWakeUpUtil() {
    }

    public static void shutdown(String macAddress, String ipAddress, PlatformEnum platform, long time, int retry) {
        switch (platform) {
            case LINUX: {
                throw new UnsupportedOperationException();
            }
            case WINDOWS: {
                String command = String.format(windowsPlatform, time, ipAddress);
                log.debug("command :{}", (Object)command);
                Process exec = Runtime.getRuntime().exec(command);
                System.out.println(exec.exitValue());
                break;
            }
            case MACOS: {
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static void powerOn(String macAddress, String ipAddress, long timeOut, long retry, String broadcastIp, int broadcastPort) {
        new WOLNode(macAddress, broadcastIp, broadcastPort).wakeUP();
    }
}

