/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.util.wol;

import cn.ximcloud.homekit.core.starter.util.wol.exception.UnableToWakeUpWOLNodeException;
import cn.ximcloud.homekit.core.starter.util.wol.validator.MacAddressValidator;
import com.google.common.collect.Lists;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WOLNode {
    private static final Logger log = LoggerFactory.getLogger(WOLNode.class);
    private static final String EMPTY_STIRNG = "";
    public static final String BROADCAST_IP = "255.255.255.255";
    public static final int WOL_PORT = 9;
    private String macAddress = null;
    private String broadcastIp = null;
    private int broadcastPort;

    public WOLNode(String macAddress) {
        this.macAddress = macAddress;
        this.broadcastIp = BROADCAST_IP;
        this.broadcastPort = 9;
    }

    public WOLNode(String macAddress, String broadcastIp, int broadcastPort) {
        this.macAddress = macAddress;
        this.broadcastIp = broadcastIp;
        this.broadcastPort = broadcastPort;
    }

    public void wakeUP() throws UnableToWakeUpWOLNodeException {
        log.debug("wakeUP():start");
        try {
            this.validate();
            this.send();
        }
        catch (Exception e) {
            log.error("An error has occurred while sending the magic package.", (Throwable)e);
            throw new UnableToWakeUpWOLNodeException("An error has occurred while sending the magic package.", e);
        }
        finally {
            log.debug("wakeUP():end");
        }
    }

    private void validate() throws IllegalArgumentException {
        log.debug("validate():start");
        if (this.macAddress == null || this.macAddress != null && EMPTY_STIRNG.equals(this.macAddress.trim())) {
            log.debug("validate():end");
            throw new IllegalArgumentException("The Mac address must be provided.");
        }
        if (!MacAddressValidator.validate(this.macAddress)) {
            log.debug("validate():start");
            throw new IllegalArgumentException("Invalid MAC address.");
        }
    }

    private void send() throws Exception {
        try (DatagramSocket socket = null;){
            int i;
            byte[] macBytes = this.getMacBytes();
            byte[] bytes = new byte[6 + 16 * macBytes.length];
            for (i = 0; i < 6; ++i) {
                bytes[i] = -1;
            }
            for (i = 6; i < bytes.length; i += macBytes.length) {
                System.arraycopy(macBytes, 0, bytes, i, macBytes.length);
            }
            InetAddress address = InetAddress.getByName(this.broadcastIp);
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length, address, this.broadcastPort);
            socket = new DatagramSocket();
            socket.send(packet);
            socket.close();
        }
    }

    private void clean() {
        this.macAddress = this.macAddress.replaceAll("\\:|\\.|\\-", EMPTY_STIRNG);
    }

    private String[] split() {
        ArrayList splittedMac = Lists.newArrayList();
        String[] result = new String[6];
        for (int i = 0; i < this.macAddress.length(); i += 2) {
            splittedMac.add(this.macAddress.substring(i, i + 2));
        }
        splittedMac.toArray(result);
        return result;
    }

    private byte[] getMacBytes() throws IllegalArgumentException {
        this.clean();
        byte[] bytes = new byte[6];
        String[] hex = this.split();
        for (int i = 0; i < 6; ++i) {
            bytes[i] = (byte)Integer.parseInt(hex[i], 16);
        }
        return bytes;
    }

    public static WOLNode create(String macAddress) {
        return new WOLNode(macAddress);
    }

    public static WOLNode create(String macAddress, String broadcast, int port) {
        return new WOLNode(macAddress, broadcast, port);
    }

    public static WOLNode create(String macAddress, String broadcast) {
        return new WOLNode(macAddress, broadcast, 9);
    }
}

