package cn.ximcloud.homekit.core.starter.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

import static cn.ximcloud.homekit.core.starter.config.HomeKitConfig.HOMEKIT_CONFIG;


/**
 * XIMCloud HomeKit Config
 *
 * @author wizard
 */
@Data
@Component
@Configuration
@ConfigurationProperties(prefix = HOMEKIT_CONFIG)
public class HomeKitConfig {

    public static final String HOMEKIT_CONFIG = "ximcloud.homekit";

    /**
     * IP地址
     */
    private String ipAddress;


    /**
     * apple homekit 端口默认9123
     */
    private Integer port = 9123;

    /**
     * 标签
     * label for the bridge. This will show in iOS during pairing.
     */
    private String label;

    /**
     * 制造商
     * manufacturer of the bridge. This information is exposed to iOS for unknown
     * purposes.
     */
    private String manufacturer;

    /**
     * 产品/型号
     * model of the bridge. This is also exposed to iOS for unknown purposes.
     */
    private String model;

    /**
     * serial number of the bridge. Also exposed. Purposes also unknown.
     */
    private String serialNumber;

    private String firmwareRevision;

    private String hardwareRevision;

}
