package cn.ximcloud.homekit.core.starter.config;


import cn.ximcloud.homekit.core.starter.constants.DataSourceConstant;
import cn.ximcloud.homekit.core.starter.core.condition.BaseOnDatabaseHomeKitCondition;
import lombok.Data;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

import static cn.ximcloud.homekit.core.starter.config.HomeKitDataSourceConfig.DATA_SOURCE_CONFIG_PREFIX;

@Data
@Component
@Configuration
@AutoConfigureBefore(BaseOnDatabaseHomeKitCondition.class)
@ConfigurationProperties(prefix = DATA_SOURCE_CONFIG_PREFIX)
public class HomeKitDataSourceConfig {

    public static final String DATA_SOURCE_CONFIG_PREFIX = "ximcloud.homekit.datasource";

    private DataSourceConstant type = DataSourceConstant.SIMPLE_DEMO;

    private String file;

}
