package cn.ximcloud.homekit.core.starter.core.adapter;

import cn.ximcloud.homekit.core.starter.core.condition.BaseOnDatabaseHomeKitCondition;
import cn.ximcloud.homekit.core.starter.core.condition.EmbeddedDataBaseCondition;
import cn.ximcloud.homekit.core.starter.core.condition.SimpleDemoHomeKitCondition;
import cn.ximcloud.homekit.core.starter.core.service.impl.BaseOnDataBaseHomeKitService;
import cn.ximcloud.homekit.core.starter.core.service.impl.SimpleDemoHomeKitService;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

import javax.sql.DataSource;

@Slf4j
@Component
@Configuration
@AutoConfigureBefore(DataSource.class)
public class HomeKitServiceAdapter {

    static {
        log.info("init homekit service adapter");
    }

    @Bean
    @Conditional(SimpleDemoHomeKitCondition.class)
    public HomeKitService generateSimpleDemoHomeKitServiceWithCondition() {
        log.info("using simple demo homekit service");
        return new SimpleDemoHomeKitService();
    }

    @Bean
    @Conditional(EmbeddedDataBaseCondition.class)
    public HomeKitService generateEmbeddedDataBaseHomeKitServiceWithCondition() {
        log.info("using base on database homekit service");
        return new BaseOnDataBaseHomeKitService();
    }

    @Bean
    @Conditional(BaseOnDatabaseHomeKitCondition.class)
    public HomeKitService generateDataBaseHomeKitServiceWithCondition() {
        log.info("using base on database homekit service");
        return new BaseOnDataBaseHomeKitService();
    }
}
