package cn.ximcloud.homekit.core.starter.core.service.impl;

import cn.ximcloud.homekit.core.enums.InvokeTypeEnum;
import cn.ximcloud.homekit.core.model.HomeKitAccessoryConfig;
import cn.ximcloud.homekit.core.model.HomeKitAccessoryTypeConfig;
import cn.ximcloud.homekit.core.model.ReturnArg;
import cn.ximcloud.homekit.core.proxy.HomeKitAccessoryProxyFactory;
import cn.ximcloud.homekit.core.starter.auth.SimpleDemoHomeKitAuthInfo;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitService;
import io.github.hapjava.accessories.HomekitAccessory;
import io.github.hapjava.accessories.SwitchAccessory;
import io.github.hapjava.server.HomekitAuthInfo;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;


@Slf4j
public class SimpleDemoHomeKitService implements HomeKitService {

    private HomekitAuthInfo homeKitAuthInfo = new SimpleDemoHomeKitAuthInfo();

    /**
     * 获取HomeKit 配置
     *
     * @return MockAuthInfo
     */
    @SneakyThrows
    @Override
    public HomekitAuthInfo getAuthInfo() {
        return homeKitAuthInfo;
    }

    /**
     * 设备列表
     *
     * @return List<HomeKitAccessory>
     */
    @Override
    public List<HomekitAccessory> getAccessoryList() {
        ArrayList<HomekitAccessory> homekitAccessories = new ArrayList<>();
        homekitAccessories.add(generateSimpleDemoSwitchAccessory());
        return homekitAccessories;
    }

    @SneakyThrows
    private HomekitAccessory generateSimpleDemoSwitchAccessory() {
        HomeKitAccessoryConfig homeKitAccessory = new HomeKitAccessoryConfig();
        homeKitAccessory.setId(2);
        homeKitAccessory.setName(CompletableFuture.completedFuture("XIMCloud 爆炸的开关"));
        homeKitAccessory.setSerialNumber(CompletableFuture.completedFuture("XIMCloud0.0.1"));
        homeKitAccessory.setModel(CompletableFuture.completedFuture("巨大的开关"));
        homeKitAccessory.setManufacturer(CompletableFuture.completedFuture("XIMCloud Works"));
        homeKitAccessory.setFirmwareRevision(CompletableFuture.completedFuture("0.0.1"));
        Map<Class<? extends HomekitAccessory>, List<HomeKitAccessoryTypeConfig>> map = new HashMap<>();
        List<HomeKitAccessoryTypeConfig> homeKitAccessoryTypeConfig = new ArrayList<>();

        HomeKitAccessoryTypeConfig config = new HomeKitAccessoryTypeConfig();
        config.setMethod(SwitchAccessory.class.getMethod("getSwitchState"));
        config.setInvokeType(InvokeTypeEnum.VALUE);
        ReturnArg arg = new ReturnArg();
        arg.setArg("true");
        config.setReturnArg(arg);
        homeKitAccessoryTypeConfig.add(config);

        config = new HomeKitAccessoryTypeConfig();
        config.setMethod(SwitchAccessory.class.getMethod("setSwitchState", boolean.class));
        config.setInvokeType(InvokeTypeEnum.VALUE);
        homeKitAccessoryTypeConfig.add(config);


        map.put(SwitchAccessory.class, homeKitAccessoryTypeConfig);
        homeKitAccessory.setAccessoryTypeMap(map);
        HomeKitAccessoryProxyFactory homeKitAccessoryProxyFactory = new HomeKitAccessoryProxyFactory(homeKitAccessory);

        new Thread(() -> {
            boolean flag = true;
            while (true) {
                arg.setArg(flag ? "true" : "false");
                flag = !flag;
                log.info("the flag value is:{}", arg.getArg());
                try {
                    TimeUnit.SECONDS.sleep(30);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }).start();

        return homeKitAccessoryProxyFactory.newInstance();
    }

}
