package cn.ximcloud.homekit.core.starter.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * ported code from https://github.com/gtanner/qrcode-terminal
 */
@Slf4j
public class QrToConsole {

    private static final char WHITE_ALL = '\u2588';
    private static final char WHITE_BLACK = '\u2580';
    private static final char BLACK_WHITE = '\u2584';
    private static final char BLACK_ALL = ' ';
    private static final String NEW_LINE = "\r\n";

    private QrToConsole() {
    }

    public static String transformQr(String setupUri) {
        StringBuilder stringBuffer = new StringBuilder(NEW_LINE);
        try {
            BitMatrix matrix = new MultiFormatWriter().encode(
                    setupUri, BarcodeFormat.QR_CODE, 10,
                    30);
            for (int y = 0; y < matrix.getHeight(); y += 2) {
                for (int x = 0; x < matrix.getWidth(); x++) {
                    boolean firstRow = matrix.get(x, y);
                    boolean secondRow = matrix.get(x, y + 1);
                    if (firstRow && secondRow) {
                        stringBuffer.append(BLACK_ALL);
                    } else if (firstRow) {
                        stringBuffer.append(BLACK_WHITE);
                    } else if (secondRow) {
                        stringBuffer.append(WHITE_BLACK);
                    } else {
                        stringBuffer.append(WHITE_ALL);
                    }
                }
                stringBuffer.append(NEW_LINE);
            }
        } catch (WriterException e) {
            log.error("error creating qr code", e);
        }
        return stringBuffer.toString();
    }
}
