/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.boot.autoconfigure;

import cn.xphsc.openstack.boot.autoconfigure.CloudClientExternalProperties;
import cn.xphsc.openstack.core.CloudClientTemplate;
import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.compute.FlavorService;
import cn.xphsc.openstack.core.client.compute.ImageService;
import cn.xphsc.openstack.core.client.compute.ImageV2Service;
import cn.xphsc.openstack.core.client.compute.KeypairService;
import cn.xphsc.openstack.core.client.compute.ServerService;
import cn.xphsc.openstack.core.client.compute.SnapshotService;
import cn.xphsc.openstack.core.client.compute.StackService;
import cn.xphsc.openstack.core.client.compute.service.FlavorServiceImpl;
import cn.xphsc.openstack.core.client.compute.service.ImageServiceImpl;
import cn.xphsc.openstack.core.client.compute.service.ImageV2ServiceImpl;
import cn.xphsc.openstack.core.client.compute.service.KeypairServiceImpl;
import cn.xphsc.openstack.core.client.compute.service.ServerServiceImpl;
import cn.xphsc.openstack.core.client.compute.service.SnapshotServiceImpl;
import cn.xphsc.openstack.core.client.compute.service.StackServiceImpl;
import cn.xphsc.openstack.core.client.container.ContainerQuotaSetService;
import cn.xphsc.openstack.core.client.container.ContainerService;
import cn.xphsc.openstack.core.client.container.service.ContainerQuotaSetServiceImpl;
import cn.xphsc.openstack.core.client.container.service.ContainerServiceImpl;
import cn.xphsc.openstack.core.client.heat.EventsService;
import cn.xphsc.openstack.core.client.heat.ResourcesService;
import cn.xphsc.openstack.core.client.heat.StackTemplateService;
import cn.xphsc.openstack.core.client.heat.service.EventsServiceImpl;
import cn.xphsc.openstack.core.client.heat.service.ResourcesServiceImpl;
import cn.xphsc.openstack.core.client.heat.service.StackTemplateServiceImpl;
import cn.xphsc.openstack.core.client.network.FloatingIpService;
import cn.xphsc.openstack.core.client.network.NetworkService;
import cn.xphsc.openstack.core.client.network.PortService;
import cn.xphsc.openstack.core.client.network.RouterService;
import cn.xphsc.openstack.core.client.network.SecurityGroupService;
import cn.xphsc.openstack.core.client.network.SubnetService;
import cn.xphsc.openstack.core.client.network.VpnService;
import cn.xphsc.openstack.core.client.network.service.FloatingIpServiceImpl;
import cn.xphsc.openstack.core.client.network.service.NetworkExternalService;
import cn.xphsc.openstack.core.client.network.service.NetworkServiceImpl;
import cn.xphsc.openstack.core.client.network.service.PortServiceImpl;
import cn.xphsc.openstack.core.client.network.service.RouterServiceImpl;
import cn.xphsc.openstack.core.client.network.service.SecurityGroupServiceImpl;
import cn.xphsc.openstack.core.client.network.service.SubnetServiceImpl;
import cn.xphsc.openstack.core.client.network.service.VpnServiceImpl;
import cn.xphsc.openstack.core.client.statistics.ResourceStatisticsService;
import cn.xphsc.openstack.core.client.statistics.service.ResourceStatisticsServiceImpl;
import cn.xphsc.openstack.core.client.volume.VolumeService;
import cn.xphsc.openstack.core.client.volume.service.VolumeServiceImpl;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableConfigurationProperties(value={CloudClientExternalProperties.class})
public class CloudClientAutoconfigure {
    private final OpenstackTemplate openstackTemplate;
    private final CloudClientExternalProperties cloudClientExternalProperties;

    public CloudClientAutoconfigure(OpenstackTemplate openstackTemplate, CloudClientExternalProperties cloudClientExternalProperties, ThreadPoolTaskExecutor serverQueryExecutor) {
        this.openstackTemplate = openstackTemplate;
        this.cloudClientExternalProperties = cloudClientExternalProperties;
    }

    @Bean
    public ImageService imageService() {
        return new ImageServiceImpl(this.openstackTemplate);
    }

    @Bean
    public FlavorService flavorService() {
        return new FlavorServiceImpl(this.openstackTemplate);
    }

    @Bean
    public KeypairService keypairService() {
        return new KeypairServiceImpl(this.openstackTemplate);
    }

    @Bean
    public SnapshotService snapshotService() {
        return new SnapshotServiceImpl(this.openstackTemplate);
    }

    @Bean
    public StackService stackService() {
        return new StackServiceImpl(this.openstackTemplate);
    }

    @Bean
    public NetworkExternalService opsNetworkService() {
        return new NetworkExternalService(this.openstackTemplate);
    }

    @Bean
    public SubnetService subnetService() {
        return new SubnetServiceImpl(this.openstackTemplate);
    }

    @Bean
    public NetworkService networkService() {
        return new NetworkServiceImpl(this.openstackTemplate, this.subnetService(), this.opsNetworkService(), this.cloudClientExternalProperties);
    }

    @Bean
    public FloatingIpService floatingIpService() {
        return new FloatingIpServiceImpl(this.openstackTemplate, this.networkService());
    }

    @Bean
    public ServerService serverService() {
        return new ServerServiceImpl(this.openstackTemplate, this.flavorService(), this.networkService(), this.floatingIpService());
    }

    @Bean
    public PortService portService() {
        return new PortServiceImpl(this.openstackTemplate);
    }

    @Bean
    public RouterService routerService() {
        return new RouterServiceImpl(this.openstackTemplate);
    }

    @Bean
    public SecurityGroupService securityGroupService() {
        return new SecurityGroupServiceImpl(this.openstackTemplate);
    }

    @Bean
    public ContainerService containerService() {
        return new ContainerServiceImpl(this.openstackTemplate, this.floatingIpService());
    }

    @Bean
    public VolumeService volumeService() {
        return new VolumeServiceImpl(this.openstackTemplate);
    }

    @Bean
    public ContainerQuotaSetService containerQuotaSetService() {
        return new ContainerQuotaSetServiceImpl(this.openstackTemplate);
    }

    @Bean
    public ResourceStatisticsService resourceStatisticsService() {
        return new ResourceStatisticsServiceImpl(this.openstackTemplate, this.containerQuotaSetService(), this.securityGroupService());
    }

    @Bean
    public VpnService vpnService() {
        return new VpnServiceImpl();
    }

    @Bean
    public EventsService eventsService() {
        return new EventsServiceImpl(this.openstackTemplate);
    }

    @Bean
    public ResourcesService resourcesService() {
        return new ResourcesServiceImpl(this.openstackTemplate);
    }

    @Bean
    public StackTemplateService stackTemplateService() {
        return new StackTemplateServiceImpl(this.openstackTemplate, this.cloudClientExternalProperties);
    }

    @Bean
    public ImageV2Service imageV2Service() {
        return new ImageV2ServiceImpl(this.openstackTemplate);
    }

    @Bean
    public CloudClientTemplate cloudClientTemplate() {
        return new CloudClientTemplate(this.imageService(), this.flavorService(), this.keypairService(), this.snapshotService(), this.stackService(), this.subnetService(), this.networkService(), this.floatingIpService(), this.serverService(), this.portService(), this.routerService(), this.securityGroupService(), this.volumeService(), this.containerService(), this.containerQuotaSetService(), this.eventsService(), this.resourcesService(), this.stackTemplateService(), this.imageV2Service(), this.resourceStatisticsService());
    }
}

