/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.compute.external.impl;

import cn.xphsc.openstack.core.client.compute.external.ImageV3Service;
import cn.xphsc.openstack.utils.Strings;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.image.v2.Image;

public class ImageV3ServiceImpl
implements ImageV3Service {
    private final OSClient.OSClientV3 osClient;
    private final String endpoint;
    private final ObjectMapper objectMapper;
    private final String endpointUrl;

    public ImageV3ServiceImpl(OSClient.OSClientV3 osClient) {
        this.osClient = osClient;
        this.endpoint = osClient.getEndpoint();
        this.endpointUrl = Strings.substringBeforeLast(this.endpoint, ":") + ":9292";
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public int updateImage(String imageId, Image image) {
        Image ops;
        ArrayList<PatchOperation> jsonPatchOperations = new ArrayList<PatchOperation>();
        if ((image.getAdditionalPropertyValue("DESCRIPTION") != null || image.getAdditionalPropertyValue("description") != null) && (ops = this.osClient.imagesV2().get(imageId)) != null) {
            PatchOperation descriptionPatchOperation;
            if (image.getAdditionalPropertyValue("DESCRIPTION") != "") {
                if (ops.getAdditionalPropertyValue("description") != null) {
                    descriptionPatchOperation = new PatchOperation();
                    descriptionPatchOperation.setOp("replace");
                    descriptionPatchOperation.setPath("/description");
                    descriptionPatchOperation.setValue(image.getAdditionalPropertyValue("DESCRIPTION"));
                    jsonPatchOperations.add(descriptionPatchOperation);
                } else {
                    descriptionPatchOperation = new PatchOperation();
                    descriptionPatchOperation.setOp("add");
                    descriptionPatchOperation.setPath("/description");
                    descriptionPatchOperation.setValue(image.getAdditionalPropertyValue("DESCRIPTION"));
                    jsonPatchOperations.add(descriptionPatchOperation);
                }
            } else if (image.getAdditionalPropertyValue("description") != null && image.getAdditionalPropertyValue("description") != "") {
                if (ops.getAdditionalPropertyValue("description") != null) {
                    descriptionPatchOperation = new PatchOperation();
                    descriptionPatchOperation.setOp("replace");
                    descriptionPatchOperation.setPath("/description");
                    descriptionPatchOperation.setValue(image.getAdditionalPropertyValue("description"));
                    jsonPatchOperations.add(descriptionPatchOperation);
                } else {
                    descriptionPatchOperation = new PatchOperation();
                    descriptionPatchOperation.setOp("add");
                    descriptionPatchOperation.setPath("/description");
                    descriptionPatchOperation.setValue(image.getAdditionalPropertyValue("description"));
                    jsonPatchOperations.add(descriptionPatchOperation);
                }
            }
        }
        if (image.getIsProtected() != null) {
            PatchOperation protectePatchOperation = new PatchOperation();
            protectePatchOperation.setOp("replace");
            protectePatchOperation.setPath("/protected");
            protectePatchOperation.setValue(image.getIsProtected());
            jsonPatchOperations.add(protectePatchOperation);
        }
        if (image.getVisibility() != null) {
            PatchOperation visibilityPatchOperation = new PatchOperation();
            visibilityPatchOperation.setOp("replace");
            visibilityPatchOperation.setPath("/visibility");
            visibilityPatchOperation.setValue(image.getVisibility().name().toLowerCase());
            jsonPatchOperations.add(visibilityPatchOperation);
        }
        if (image.getMinDisk() != null) {
            PatchOperation minDiskPatchOperation = new PatchOperation();
            minDiskPatchOperation.setOp("replace");
            minDiskPatchOperation.setPath("/min_disk");
            minDiskPatchOperation.setValue(image.getMinDisk());
            jsonPatchOperations.add(minDiskPatchOperation);
        }
        if (image.getMinRam() != null) {
            PatchOperation minRamPatchOperation = new PatchOperation();
            minRamPatchOperation.setOp("replace");
            minRamPatchOperation.setPath("/min_ram");
            minRamPatchOperation.setValue(image.getMinRam());
            jsonPatchOperations.add(minRamPatchOperation);
        }
        if (image.getName() != null) {
            PatchOperation namePatchOperation = new PatchOperation();
            namePatchOperation.setOp("replace");
            namePatchOperation.setPath("/name");
            namePatchOperation.setValue(image.getName());
            jsonPatchOperations.add(namePatchOperation);
        }
        String patchJson = this.convertPatchOperationsToJson(jsonPatchOperations);
        String url = this.endpointUrl + "/v2/images/" + imageId;
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPatch request = new HttpPatch(url);
            request.setHeader("X-Auth-Token", this.osClient.getToken().getId());
            request.setHeader("Content-Type", "application/openstack-images-v2.1-json-patch");
            StringEntity entity = new StringEntity(patchJson, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = null;
            try {
                response = httpClient.execute((HttpUriRequest)request);
                return response.getStatusLine().getStatusCode() == 200 ? 1 : 0;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String convertPatchOperationsToJson(List<PatchOperation> operations) {
        try {
            return this.objectMapper.writeValueAsString(operations);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error serializing patch operations", e);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public class PatchOperation {
        private String op;
        private String path;
        private Object value;

        public PatchOperation() {
        }

        public PatchOperation(String op, String path, Object value) {
            this.op = op;
            this.path = path;
            this.value = value;
        }

        @JsonProperty(value="op")
        public String getOp() {
            return this.op;
        }

        public void setOp(String op) {
            this.op = op;
        }

        @JsonProperty(value="path")
        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        @JsonProperty(value="value")
        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

