/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.compute.service;

import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.compute.ImageService;
import cn.xphsc.openstack.core.client.compute.external.impl.ImageV3ServiceImpl;
import cn.xphsc.openstack.core.entity.compute.ContainerFormat;
import cn.xphsc.openstack.core.entity.compute.DiskFormat;
import cn.xphsc.openstack.core.entity.compute.Image;
import cn.xphsc.openstack.core.entity.compute.ImageType;
import cn.xphsc.openstack.core.entity.compute.ImageVisibility;
import cn.xphsc.openstack.core.entity.compute.SystemType;
import cn.xphsc.openstack.core.exception.OpenstackException;
import cn.xphsc.openstack.core.paginator.Page;
import cn.xphsc.openstack.core.paginator.PageImpl;
import cn.xphsc.openstack.core.query.PageQuery;
import cn.xphsc.openstack.core.support.ResourceWaiting;
import cn.xphsc.openstack.utils.CollectionUtils;
import cn.xphsc.openstack.utils.Dates;
import cn.xphsc.openstack.utils.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.openstack4j.api.Builders;
import org.openstack4j.api.exceptions.ClientResponseException;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.common.Payload;
import org.openstack4j.model.common.Payloads;
import org.openstack4j.model.image.v2.Image;
import org.openstack4j.model.image.v2.builder.ImageBuilder;
import org.openstack4j.model.storage.block.Volume;
import org.openstack4j.model.storage.block.VolumeSnapshot;
import org.springframework.stereotype.Component;

@Component
public class ImageServiceImpl
implements ImageService {
    private final OpenstackTemplate openstackTemplate;

    public ImageServiceImpl(OpenstackTemplate openstackTemplate) {
        this.openstackTemplate = openstackTemplate;
    }

    @Override
    public cn.xphsc.openstack.core.entity.compute.Image get(String imageId) {
        VolumeSnapshot volumeSnapshot = this.openstackTemplate.blockStorage().snapshots().get(imageId);
        if (Objects.nonNull(volumeSnapshot)) {
            return this.buildImage(volumeSnapshot);
        }
        Image image = this.openstackTemplate.imagesV2().get(imageId);
        return this.buildImage(image);
    }

    @Override
    public cn.xphsc.openstack.core.entity.compute.Image getImageByName(String name) {
        List volumeSnapshots = this.openstackTemplate.blockStorage().snapshots().list();
        Optional<VolumeSnapshot> optional = volumeSnapshots.stream().filter(volumeSnapshot -> Strings.equals(name, volumeSnapshot.getName())).findFirst();
        if (optional.isPresent()) {
            return this.buildImage(optional.get());
        }
        HashMap<String, String> filteringParams = new HashMap<String, String>();
        filteringParams.put("name", name);
        filteringParams.put("owner", this.openstackTemplate.token().getProject().getId());
        List imageList = this.openstackTemplate.imagesV2().list(filteringParams);
        return CollectionUtils.isNotEmpty(imageList) ? this.buildImage((Image)imageList.get(0)) : null;
    }

    @Override
    public List<cn.xphsc.openstack.core.entity.compute.Image> list() {
        List<cn.xphsc.openstack.core.entity.compute.Image> dockers = this.dockerImageList();
        List<cn.xphsc.openstack.core.entity.compute.Image> isos = this.isoImageList();
        List images = this.openstackTemplate.imagesV2().list(this.getDefaultFilter()).stream().filter(image -> Strings.isNotEmpty(image.getName()) && image.getStatus().equals((Object)Image.ImageStatus.ACTIVE)).map(this::buildImage).collect(Collectors.toList());
        return Stream.of(images.stream(), dockers.stream(), isos.stream()).flatMap(imageStream -> imageStream).collect(Collectors.toList());
    }

    private Map<String, String> getDefaultFilter() {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("limit", String.valueOf(10000));
        return filter;
    }

    @Override
    public Page<cn.xphsc.openstack.core.entity.compute.Image> list(PageQuery pageQuery) {
        List<cn.xphsc.openstack.core.entity.compute.Image> images = this.list();
        if (Objects.isNull(pageQuery)) {
            return PageImpl.of(images, null, null);
        }
        if (Strings.isNotBlank(pageQuery.getName())) {
            images = images.stream().filter(image -> image.getName().contains(pageQuery.getName())).collect(Collectors.toList());
        }
        return PageImpl.of(images, pageQuery.getOffset(), pageQuery.getLimit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public cn.xphsc.openstack.core.entity.compute.Image create(cn.xphsc.openstack.core.entity.compute.Image image, InputStream imageInputStream) {
        ImageBuilder imageBuilder = Builders.imageV2();
        if (image.getMinDisk() != null) {
            imageBuilder.minDisk(Long.valueOf(image.getMinDisk().longValue()));
        }
        if (image.getMinRam() != null) {
            imageBuilder.minRam(Long.valueOf(image.getMinRam().longValue()));
        }
        imageBuilder.name(image.getName()).containerFormat(org.openstack4j.model.image.v2.ContainerFormat.valueOf((String)image.getContainerFormat().toString())).diskFormat(org.openstack4j.model.image.v2.DiskFormat.valueOf((String)image.getDiskFormat().toString().toUpperCase()));
        if (image.getDescription() != null) {
            imageBuilder.additionalProperty("DESCRIPTION", image.getDescription());
        }
        if (image.getProtected() != null) {
            imageBuilder.isProtected(image.getProtected());
        }
        if (image.getImageVisibility() != null) {
            imageBuilder.visibility(Image.ImageVisibility.valueOf((String)image.getImageVisibility().name()));
        } else {
            if (image.getPublic() != null && image.getPublic().equals(true)) {
                imageBuilder.visibility(Image.ImageVisibility.PUBLIC);
            }
            if (image.getPrivate() != null && image.getPrivate().equals(true)) {
                imageBuilder.visibility(Image.ImageVisibility.PRIVATE);
            }
        }
        this.updateDiskBus(imageBuilder, image);
        this.updateVifModel(imageBuilder, image);
        this.setOsType(image, imageBuilder);
        Image opsImage = this.openstackTemplate.imagesV2().create((Image)imageBuilder.build());
        Payload payload = null;
        try {
            payload = Payloads.create((InputStream)imageInputStream);
            ActionResponse actionResponse = this.openstackTemplate.imagesV2().upload(opsImage.getId(), payload, opsImage);
            if (!actionResponse.isSuccess()) {
                this.delete(opsImage.getId());
                throw new OpenstackException(actionResponse.getFault());
            }
            image = this.buildImage(opsImage);
        }
        finally {
            if (payload != null) {
                try {
                    payload.close();
                }
                catch (IOException iOException) {}
            }
        }
        return image;
    }

    @Override
    public int update(cn.xphsc.openstack.core.entity.compute.Image image) {
        String imageId;
        if (ImageType.VOLUME_SNAPSHOT.equals((Object)image.getImageType())) {
            VolumeSnapshot volumeSnapshot = this.openstackTemplate.blockStorage().snapshots().get(image.getId());
            ActionResponse actionResponse = this.openstackTemplate.blockStorage().snapshots().update(image.getId(), image.getName(), image.getDescription());
            if (!actionResponse.isSuccess()) {
                return 0;
            }
            actionResponse = this.openstackTemplate.blockStorage().volumes().update(volumeSnapshot.getVolumeId(), image.getName(), image.getDescription());
            if (!actionResponse.isSuccess()) {
                return 0;
            }
            imageId = this.openstackTemplate.blockStorage().volumes().get(volumeSnapshot.getVolumeId()).getImageRef();
        } else {
            imageId = image.getId();
        }
        if (Strings.isBlank(imageId)) {
            return 0;
        }
        Image opsImage = this.openstackTemplate.imagesV2().get(imageId);
        ImageBuilder imageBuilder = ((ImageBuilder)opsImage.toBuilder()).name(image.getName()).additionalProperty("DESCRIPTION", Strings.isNotBlank(image.getDescription()) ? image.getDescription() : "");
        if (image.getMinDisk() != null) {
            imageBuilder.minDisk(Long.valueOf(image.getMinDisk().longValue()));
        }
        if (image.getMinRam() != null) {
            imageBuilder.minRam(Long.valueOf(image.getMinDisk().longValue()));
        }
        if (image.getProtected() != null) {
            imageBuilder.isProtected(image.getProtected());
        }
        if (image.getImageVisibility() != null) {
            imageBuilder.visibility(Image.ImageVisibility.valueOf((String)image.getImageVisibility().name()));
        } else {
            if (image.getPublic() != null && image.getPublic().equals(true)) {
                imageBuilder.visibility(Image.ImageVisibility.PUBLIC);
            }
            if (image.getPrivate() != null && image.getPrivate().equals(true)) {
                imageBuilder.visibility(Image.ImageVisibility.PRIVATE);
            }
        }
        this.updateDiskBus(imageBuilder, image);
        this.updateVifModel(imageBuilder, image);
        this.setOsType(image, imageBuilder);
        try {
            this.openstackTemplate.imagesV2().update((Image)imageBuilder.build());
        }
        catch (ClientResponseException exception) {
            ImageV3ServiceImpl imageV3Service = new ImageV3ServiceImpl(this.openstackTemplate.openstackClient());
            return imageV3Service.updateImage(((Image)imageBuilder.build()).getId(), (Image)imageBuilder.build());
        }
        return 1;
    }

    @Override
    public int delete(String imageId) {
        ActionResponse response = this.openstackTemplate.imagesV2().delete(imageId);
        return response.isSuccess() ? 1 : 0;
    }

    @Override
    public int delete(cn.xphsc.openstack.core.entity.compute.Image image) {
        if (Objects.isNull(image)) {
            return 0;
        }
        boolean isInstanceSnapshot = this.isInstanceSnapshot(image.getId());
        if (isInstanceSnapshot) {
            return this.deleteInstanceSnapshot(image.getId());
        }
        return Strings.isNotBlank(image.getVolumeSnapshotId()) ? this.deleteVolumeSnapshot(image) : this.delete(image.getId());
    }

    @Override
    public int deleteByName(String name) {
        HashMap<String, String> filter = new HashMap<String, String>(1);
        filter.put("name", name);
        List volumeSnapshotList = this.openstackTemplate.blockStorage().snapshots().list(filter);
        if (CollectionUtils.isEmpty(volumeSnapshotList)) {
            return 0;
        }
        ActionResponse actionResponse = this.openstackTemplate.blockStorage().snapshots().delete(((VolumeSnapshot)volumeSnapshotList.get(0)).getId());
        if (!actionResponse.isSuccess()) {
            return 0;
        }
        VolumeSnapshot volumeSnapshot = ResourceWaiting.waitForResource(() -> this.openstackTemplate.blockStorage().snapshots().get(((VolumeSnapshot)volumeSnapshotList.get(0)).getId()), 180, 1000);
        if (volumeSnapshot != null) {
            return 0;
        }
        Volume originVolume = this.openstackTemplate.blockStorage().volumes().get(((VolumeSnapshot)volumeSnapshotList.get(0)).getVolumeId());
        String imageId = originVolume == null ? null : originVolume.getImageRef();
        actionResponse = this.openstackTemplate.blockStorage().volumes().delete(((VolumeSnapshot)volumeSnapshotList.get(0)).getVolumeId());
        if (!actionResponse.isSuccess()) {
            return 0;
        }
        Volume volume = ResourceWaiting.waitForResource(() -> this.openstackTemplate.blockStorage().volumes().get(((VolumeSnapshot)volumeSnapshotList.get(0)).getVolumeId()), this.openstackTemplate.getWaitTimeout(), this.openstackTemplate.getIntervalTime());
        if (volume != null) {
            return 0;
        }
        if (!Strings.isEmpty(imageId)) {
            this.openstackTemplate.imagesV2().delete(imageId);
        }
        return 1;
    }

    private void setOsType(cn.xphsc.openstack.core.entity.compute.Image image, ImageBuilder imageBuilder) {
        if (Objects.nonNull((Object)image.getImageType())) {
            if (SystemType.LINUX.equals((Object)image.getSystemType())) {
                imageBuilder.additionalProperty("os_type", SystemType.LINUX.toString());
            } else if (SystemType.WINDOWS.equals((Object)image.getSystemType())) {
                imageBuilder.additionalProperty("os_type", SystemType.WINDOWS.toString());
            }
        }
    }

    private int deleteVolumeSnapshot(cn.xphsc.openstack.core.entity.compute.Image image) {
        ActionResponse response = this.openstackTemplate.blockStorage().snapshots().delete(image.getVolumeSnapshotId());
        if (!response.isSuccess()) {
            return 0;
        }
        VolumeSnapshot volumeSnapshot = ResourceWaiting.waitForResource(() -> this.openstackTemplate.blockStorage().snapshots().get(image.getVolumeSnapshotId()), this.openstackTemplate.getWaitTimeout(), this.openstackTemplate.getIntervalTime());
        if (Objects.nonNull(volumeSnapshot)) {
            return 0;
        }
        response = this.openstackTemplate.blockStorage().volumes().delete(image.getVolumeId());
        if (!response.isSuccess()) {
            return 0;
        }
        Volume volume = ResourceWaiting.waitForResource(() -> this.openstackTemplate.blockStorage().volumes().get(image.getVolumeId()), this.openstackTemplate.getWaitTimeout(), this.openstackTemplate.getIntervalTime());
        return Objects.nonNull(volume) ? 0 : this.delete(image.getId());
    }

    private boolean isInstanceSnapshot(String id) {
        VolumeSnapshot volumeSnapshot = this.openstackTemplate.blockStorage().snapshots().get(id);
        return volumeSnapshot != null;
    }

    private boolean deleteSuccess(ActionResponse response) {
        return response.isSuccess() || 404 == response.getCode();
    }

    private int deleteInstanceSnapshot(String snapshotId) {
        VolumeSnapshot volumeSnapshot = this.openstackTemplate.blockStorage().snapshots().get(snapshotId);
        ActionResponse response = this.openstackTemplate.blockStorage().snapshots().delete(snapshotId);
        if (!this.deleteSuccess(response)) {
            return 0;
        }
        VolumeSnapshot deleteVolumeSnapshot = ResourceWaiting.waitForResource(() -> this.openstackTemplate.blockStorage().snapshots().get(snapshotId), this.openstackTemplate.getWaitTimeout(), this.openstackTemplate.getIntervalTime());
        if (Objects.nonNull(deleteVolumeSnapshot)) {
            return 0;
        }
        Volume volume = this.openstackTemplate.blockStorage().volumes().get(volumeSnapshot.getVolumeId());
        if (!this.isUsingVolume(volume)) {
            this.openstackTemplate.blockStorage().volumes().delete(volume.getId());
        }
        return 1;
    }

    private List<cn.xphsc.openstack.core.entity.compute.Image> getVolumeSnapshotList() {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("limit", String.valueOf(100000));
        List volumeSnapshots = this.openstackTemplate.blockStorage().snapshots().list(filter);
        return volumeSnapshots.stream().filter(volumeSnapshot -> !com.google.common.base.Strings.isNullOrEmpty((String)volumeSnapshot.getName())).map(volumeSnapshot -> this.buildImage((VolumeSnapshot)volumeSnapshot)).collect(Collectors.toList());
    }

    private List<cn.xphsc.openstack.core.entity.compute.Image> dockerImageList() {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("limit", String.valueOf(100000));
        filter.put("container_format", ContainerFormat.DOCKER.name());
        filter.put("owner", this.openstackTemplate.openstackClient().getToken().getProject().getId());
        List dockers = this.openstackTemplate.imagesV2().list(filter);
        return dockers.stream().map(this::buildImage).collect(Collectors.toList());
    }

    private List<cn.xphsc.openstack.core.entity.compute.Image> isoImageList() {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("limit", String.valueOf(100000));
        filter.put("disk_format", DiskFormat.ISO.name());
        filter.put("owner", this.openstackTemplate.openstackClient().getToken().getProject().getId());
        List dockers = this.openstackTemplate.imagesV2().list(filter);
        return dockers.stream().map(this::buildImage).collect(Collectors.toList());
    }

    private cn.xphsc.openstack.core.entity.compute.Image buildImage(VolumeSnapshot volumeSnapshot) {
        Image openstackImage;
        if (Objects.isNull(volumeSnapshot)) {
            return null;
        }
        Image.Builder builder = cn.xphsc.openstack.core.entity.compute.Image.builder();
        builder.id(volumeSnapshot.getId());
        Volume volume = this.openstackTemplate.blockStorage().volumes().get(volumeSnapshot.getVolumeId());
        if (Objects.nonNull(volume) && Strings.isNotBlank(volume.getImageRef()) && Objects.nonNull(openstackImage = this.openstackTemplate.imagesV2().get(volume.getImageRef()))) {
            builder.diskFormat(DiskFormat.valueOf(openstackImage.getDiskFormat().name()));
            builder.containerFormat(ContainerFormat.valueOf(openstackImage.getContainerFormat().name()));
            builder.minDisk(BigDecimal.valueOf(openstackImage.getMinDisk()));
            builder.minRam(BigDecimal.valueOf(openstackImage.getMinRam()));
            builder.isProtected(openstackImage.getIsProtected());
            builder.description(openstackImage.getAdditionalPropertyValue("DESCRIPTION") != null ? openstackImage.getAdditionalPropertyValue("DESCRIPTION") : openstackImage.getAdditionalPropertyValue("description"));
        }
        builder.name(volumeSnapshot.getName());
        builder.imageType(ImageType.VOLUME_SNAPSHOT);
        builder.disk(String.valueOf(volumeSnapshot.getSize()));
        builder.size(volumeSnapshot.getSize() + "G");
        builder.createTime(Dates.formatDate(volumeSnapshot.getCreated()));
        builder.status(volumeSnapshot.getStatus().value());
        return builder.build();
    }

    private cn.xphsc.openstack.core.entity.compute.Image buildImage(Image opsImage) {
        if (Objects.isNull(opsImage)) {
            return null;
        }
        Image.Builder builder = cn.xphsc.openstack.core.entity.compute.Image.builder();
        builder.id(opsImage.getId());
        boolean isSnapShot = opsImage.getAdditionalPropertyValue("image_location") != null && "snapshot".equals(opsImage.getAdditionalPropertyValue("image_location"));
        String systemType = Strings.isNotBlank(opsImage.getAdditionalPropertyValue("os_type")) ? opsImage.getAdditionalPropertyValue("os_type") : "other";
        builder.name(opsImage.getName());
        builder.status(opsImage.getStatus().name());
        builder.imageType(isSnapShot ? ImageType.SNAPSHOT : ImageType.IMAGE);
        builder.diskFormat(Objects.nonNull(opsImage.getDiskFormat()) ? DiskFormat.valueOf(opsImage.getDiskFormat().name()) : null);
        builder.containerFormat(Objects.nonNull(opsImage.getContainerFormat()) ? ContainerFormat.valueOf(opsImage.getContainerFormat().name()) : null);
        builder.isPublic("PUBLIC".equalsIgnoreCase(opsImage.getVisibility().toString()));
        builder.isPrivate("PRIVATE".equalsIgnoreCase(opsImage.getVisibility().toString()));
        builder.imageVisibility(ImageVisibility.valueOf(opsImage.getVisibility().name()));
        builder.createTime(Dates.formatDate(opsImage.getCreatedAt()));
        String imageSize = this.getImageSize(Objects.nonNull(opsImage.getSize()) ? opsImage.getSize() : 0L);
        builder.size(imageSize);
        this.getImageSize(Objects.nonNull(opsImage.getSize()) ? opsImage.getSize() : 0L);
        builder.disk(imageSize.substring(0, imageSize.length() - 1));
        builder.isProtected(opsImage.getIsProtected());
        builder.minDisk(BigDecimal.valueOf(opsImage.getMinDisk()));
        builder.minRam(BigDecimal.valueOf(opsImage.getMinRam()));
        builder.description(opsImage.getAdditionalPropertyValue("DESCRIPTION") != null ? opsImage.getAdditionalPropertyValue("DESCRIPTION") : opsImage.getAdditionalPropertyValue("description"));
        builder.systemType(SystemType.fromValue(systemType));
        builder.hwDiskBus(opsImage.getAdditionalPropertyValue("hw_disk_bus") != null ? opsImage.getAdditionalPropertyValue("hw_disk_bus") : null);
        builder.hwVifModel(opsImage.getAdditionalPropertyValue("hw_vif_model") != null ? opsImage.getAdditionalPropertyValue("hw_vif_model") : null);
        cn.xphsc.openstack.core.entity.compute.Image image = builder.build();
        return image;
    }

    private boolean isUsingVolume(Volume volume) {
        return CollectionUtils.isNotEmpty(volume.getAttachments()) || volume.getAttachments().stream().anyMatch(attachment -> !Strings.isEmpty(attachment.getServerId()));
    }

    private void updateDiskBus(ImageBuilder imageBuilder, cn.xphsc.openstack.core.entity.compute.Image image) {
        if (StringUtils.isNotEmpty((CharSequence)image.getHwDiskBus())) {
            imageBuilder.additionalProperty("hw_disk_bus", image.getHwDiskBus());
        }
    }

    private void updateVifModel(ImageBuilder imageBuilder, cn.xphsc.openstack.core.entity.compute.Image image) {
        if (StringUtils.isNotEmpty((CharSequence)image.getHwVifModel())) {
            imageBuilder.additionalProperty("hw_vif_model", image.getHwVifModel());
        }
    }

    private String getImageSize(long imgSize) {
        DecimalFormat df = new DecimalFormat("#.0");
        String fileSizeString = "";
        fileSizeString = imgSize < 1024L ? df.format((double)imgSize) + "B" : (imgSize < 0x100000L ? df.format((double)imgSize / 1024.0) + "K" : (imgSize < 0x40000000L ? df.format((double)imgSize / 1048576.0) + "M" : df.format((double)imgSize / 1.073741824E9) + "G"));
        return fileSizeString;
    }
}

