/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.compute.service;

import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.compute.ImageV2Service;
import cn.xphsc.openstack.core.client.compute.external.impl.ImageV3ServiceImpl;
import cn.xphsc.openstack.core.entity.compute.Connection;
import cn.xphsc.openstack.core.entity.compute.ContainerFormat;
import cn.xphsc.openstack.core.entity.compute.DiskFormat;
import cn.xphsc.openstack.core.entity.compute.ImageType;
import cn.xphsc.openstack.core.entity.compute.ImageVisibility;
import cn.xphsc.openstack.core.entity.compute.ScanStatus;
import cn.xphsc.openstack.core.entity.compute.v2.ImageStatus;
import cn.xphsc.openstack.core.entity.compute.v2.LocalImage;
import cn.xphsc.openstack.core.entity.compute.v2.VerifyResult;
import cn.xphsc.openstack.core.exception.OpenstackException;
import cn.xphsc.openstack.core.paginator.Page;
import cn.xphsc.openstack.core.paginator.PageImpl;
import cn.xphsc.openstack.core.query.PageQuery;
import cn.xphsc.openstack.utils.CollectionUtils;
import cn.xphsc.openstack.utils.Jacksons;
import cn.xphsc.openstack.utils.Md5Utils;
import cn.xphsc.openstack.utils.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openstack4j.api.Builders;
import org.openstack4j.api.exceptions.ClientResponseException;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.common.Payload;
import org.openstack4j.model.common.Payloads;
import org.openstack4j.model.image.v2.Image;
import org.openstack4j.model.image.v2.builder.ImageBuilder;
import org.springframework.stereotype.Component;

@Component
public class ImageV2ServiceImpl
implements ImageV2Service {
    private final OpenstackTemplate openstackTemplate;

    public ImageV2ServiceImpl(OpenstackTemplate openstackTemplate) {
        this.openstackTemplate = openstackTemplate;
    }

    @Override
    public LocalImage get(String imageId) {
        Image image = this.openstackTemplate.imagesV2().get(imageId);
        return Objects.nonNull(image) ? this.translateImage(image) : null;
    }

    @Override
    public LocalImage getImageByName(String name) {
        HashMap<String, String> filteringParams = new HashMap<String, String>();
        filteringParams.put("name", name);
        List imageList = this.openstackTemplate.imagesV2().list(filteringParams);
        return CollectionUtils.isNotEmpty(imageList) ? this.translateImage((Image)imageList.get(0)) : null;
    }

    @Override
    public List<LocalImage> list() {
        return this.openstackTemplate.imagesV2().list(this.getDefaultFilter()).stream().filter(image -> StringUtils.isNotEmpty((CharSequence)image.getName()) && image.getStatus().equals((Object)Image.ImageStatus.ACTIVE)).map(this::translateImage).collect(Collectors.toList());
    }

    @Override
    public Page<LocalImage> list(PageQuery pageQuery) {
        List<LocalImage> images = this.list();
        if (Objects.isNull(pageQuery)) {
            return PageImpl.of(images, null, null);
        }
        if (StringUtils.isNotBlank((CharSequence)pageQuery.getName())) {
            images = images.stream().filter(image -> image.getName().contains(pageQuery.getName())).collect(Collectors.toList());
        }
        return PageImpl.of(images, pageQuery.getOffset(), pageQuery.getLimit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalImage create(LocalImage image, InputStream imageInputStream) {
        LocalImage localImage;
        ImageBuilder imageBuilder = Builders.imageV2().name(image.getName()).containerFormat(org.openstack4j.model.image.v2.ContainerFormat.valueOf((String)image.getContainerFormat().toString())).diskFormat(org.openstack4j.model.image.v2.DiskFormat.valueOf((String)image.getDiskFormat().toString().toUpperCase()));
        if (image.getMinDisk() != null) {
            imageBuilder.minDisk(Long.valueOf(image.getMinDisk().longValue()));
        }
        if (image.getMinRam() != null) {
            imageBuilder.minRam(Long.valueOf(image.getMinRam().longValue()));
        }
        if (image.getProtected() != null) {
            imageBuilder.isProtected(image.getProtected());
        }
        if (image.getImageVisibility() != null) {
            imageBuilder.visibility(Image.ImageVisibility.valueOf((String)image.getImageVisibility().name()));
        }
        this.updatePropertyToImageBuilder(imageBuilder, image);
        Image opsImage = this.openstackTemplate.imagesV2().create((Image)imageBuilder.build());
        Payload payload = null;
        try {
            payload = Payloads.create((InputStream)imageInputStream);
            ActionResponse actionResponse = this.openstackTemplate.imagesV2().upload(opsImage.getId(), payload, opsImage);
            if (!actionResponse.isSuccess()) {
                this.delete(opsImage.getId());
                throw new OpenstackException(actionResponse.getFault());
            }
            opsImage = this.openstackTemplate.imagesV2().get(opsImage.getId());
            localImage = this.translateImage(opsImage);
        }
        finally {
            if (payload != null) {
                try {
                    payload.close();
                }
                catch (IOException iOException) {}
            }
        }
        return localImage;
    }

    @Override
    public int update(LocalImage image) {
        Image opsImage = this.openstackTemplate.imagesV2().get(image.getImageId());
        if (Objects.isNull(opsImage)) {
            return 0;
        }
        ImageBuilder imageBuilder = ((ImageBuilder)opsImage.toBuilder()).name(image.getName());
        this.updatePropertyToImageBuilder(imageBuilder, image);
        try {
            this.openstackTemplate.imagesV2().update((Image)imageBuilder.build());
        }
        catch (ClientResponseException exception) {
            ImageV3ServiceImpl imageV3Service = new ImageV3ServiceImpl(this.openstackTemplate.openstackClient());
            return imageV3Service.updateImage(((Image)imageBuilder.build()).getId(), (Image)imageBuilder.build());
        }
        return 1;
    }

    @Override
    public ActionResponse delete(String imageId) {
        ActionResponse response = this.openstackTemplate.imagesV2().delete(imageId);
        return response;
    }

    @Override
    public ActionResponse delete(LocalImage image) {
        return Objects.nonNull(image) ? this.delete(image.getImageId()) : ActionResponse.actionSuccess();
    }

    @Override
    public ActionResponse deleteByName(String name) {
        HashMap<String, String> filter = new HashMap<String, String>(1);
        filter.put("name", name);
        List images = this.openstackTemplate.imagesV2().list(filter);
        return CollectionUtils.isNotEmpty(images) ? this.delete(((Image)images.get(0)).getId()) : ActionResponse.actionSuccess();
    }

    private LocalImage translateImage(Image opsImage) {
        if (Objects.isNull(opsImage)) {
            return null;
        }
        LocalImage.Builder image = LocalImage.builder();
        image.imageId(opsImage.getId());
        if (opsImage.getVisibility() != null) {
            image.imageVisibility(ImageVisibility.valueOf(opsImage.getVisibility().name()));
        }
        if (opsImage.getIsProtected().booleanValue()) {
            image.isProtected(opsImage.getIsProtected());
        }
        boolean isSnapShot = "snapshot".equals(opsImage.getAdditionalPropertyValue("image_location"));
        image.description(opsImage.getAdditionalPropertyValue("DESCRIPTION") != null ? opsImage.getAdditionalPropertyValue("DESCRIPTION") : opsImage.getAdditionalPropertyValue("description"));
        image.name(opsImage.getName()).imageType(isSnapShot ? ImageType.SNAPSHOT : ImageType.IMAGE).diskFormat(DiskFormat.valueOf(opsImage.getDiskFormat().name())).status(ImageStatus.fromValue(opsImage.getStatus().name())).containerFormat(ContainerFormat.valueOf(opsImage.getContainerFormat().name())).size(Objects.nonNull(opsImage.getSize()) ? this.getImageSize(opsImage.getSize()) : "0B").minDisk(opsImage.getMinDisk().intValue()).minRam(opsImage.getMinRam().intValue()).updateTime(this.formatDate(opsImage.getUpdatedAt())).createTime(this.formatDate(opsImage.getCreatedAt()));
        this.setProperties(opsImage, image);
        return image.build();
    }

    private void setProperties(Image opsImage, LocalImage.Builder image) {
        String hwVifModel;
        LocalImage newimage;
        String imageProperties = opsImage.getAdditionalPropertyValue("image_properties");
        if (StringUtils.isNotEmpty((CharSequence)imageProperties)) {
            Map jsonObject = Jacksons.toJsonObject(imageProperties, Map.class);
            image.osType((String)jsonObject.get("os_type")).description((String)jsonObject.get("description")).architecture((String)jsonObject.get("architecture")).osVersion((String)jsonObject.get("os_version")).osDistro((String)jsonObject.get("os_distro")).scanStatus(ScanStatus.fromValue((String)jsonObject.get("scan_status"))).vulnerabilities(CollectionUtils.isNotEmpty((Collection)jsonObject.get("vulnerabilities")) ? Jacksons.toJsonObject(Jacksons.toJSONString(jsonObject.get("vulnerabilities")), List.class) : null).tags(CollectionUtils.isNotEmpty((Collection)jsonObject.get("tags")) ? Jacksons.toJsonObject(Jacksons.toJSONString(jsonObject.get("tags")), List.class) : null).hwDiskBus((String)jsonObject.get("hw_disk_bus")).hwVifModel((String)jsonObject.get("hw_vif_model")).flavor((String)jsonObject.get("flavor")).user((String)jsonObject.get("user")).password((String)jsonObject.get("password")).rdpPort((Integer)jsonObject.get("rdp_port")).sshPort((Integer)jsonObject.get("ssh_port")).httpConnection(Jacksons.toJsonObject(Jacksons.toJSONString(jsonObject.get("http_connection")), Connection.class)).httpsConnection(Jacksons.toJsonObject(Jacksons.toJSONString(jsonObject.get("https_connection")), Connection.class)).vnc((Boolean)jsonObject.get("vnc")).cloudInit((Boolean)jsonObject.get("cloud_init")).qemuGuestAgent((Boolean)jsonObject.get("hw_qemu_guest_agent")).telemetryAgent((Boolean)jsonObject.get("telemetry_agent")).cancelVerify((Boolean)jsonObject.get("cancel_verify")).cancelVerifyReason((String)jsonObject.get("cancel_verify_reason")).status(ImageStatus.fromValue((String)jsonObject.get("status"))).verifyTime((String)jsonObject.get("verify_time")).verifyResult(Jacksons.toJsonObject(Jacksons.toJSONString(jsonObject.get("verify_result")), VerifyResult.class));
            String originDiskFormat = (String)jsonObject.get("origin_disk_format");
            if (StringUtils.isNotEmpty((CharSequence)originDiskFormat)) {
                image.diskFormat(DiskFormat.valueOf(originDiskFormat));
            }
            this.setImageStatus(image, jsonObject);
        }
        if (StringUtils.isEmpty((CharSequence)(newimage = image.build()).getOsType())) {
            hwVifModel = opsImage.getAdditionalPropertyValue("os_type");
            image.osType(StringUtils.isNotEmpty((CharSequence)hwVifModel) ? hwVifModel : null);
        }
        if (StringUtils.isEmpty((CharSequence)newimage.getHwDiskBus())) {
            hwVifModel = opsImage.getAdditionalPropertyValue("hw_disk_bus");
            image.hwDiskBus(StringUtils.isNotEmpty((CharSequence)hwVifModel) ? hwVifModel : null);
        }
        if (StringUtils.isNotBlank((CharSequence)(hwVifModel = opsImage.getAdditionalPropertyValue("hw_vif_model")))) {
            image.hwVifModel(StringUtils.isNotEmpty((CharSequence)hwVifModel) ? hwVifModel : "virtio");
        }
    }

    private String getImageSize(long imgSize) {
        DecimalFormat df = new DecimalFormat("0.#");
        String fileSizeString = "";
        fileSizeString = imgSize < 1024L ? df.format((double)imgSize) + "B" : (imgSize < 0x100000L ? df.format((double)imgSize / 1024.0) + "K" : (imgSize < 0x40000000L ? df.format((double)imgSize / 1048576.0) + "M" : df.format((double)imgSize / 1.073741824E9) + "G"));
        return fileSizeString;
    }

    private String formatDate(Date created) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(created);
    }

    private void setImageStatus(LocalImage.Builder image, Map jsonObject) {
        String status = (String)jsonObject.get("status");
        String opsSign = (String)jsonObject.get("sign");
        if (StringUtils.isEmpty((CharSequence)status) || StringUtils.isEmpty((CharSequence)opsSign) || !opsSign.equals(this.generateSign(image.build()))) {
            image.status(null);
            image.verifyTime(null);
        }
    }

    private String generateSign(LocalImage image) {
        if (ImageStatus.VERIFIED.equals((Object)image.getStatus())) {
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            map.put("name", image.getName());
            if (StringUtils.isNotEmpty((CharSequence)image.getOsVersion())) {
                map.put("os_version", image.getOsVersion());
            }
            if (StringUtils.isNotEmpty((CharSequence)image.getFlavor())) {
                map.put("flavor", image.getFlavor());
            }
            if (StringUtils.isNotEmpty((CharSequence)image.getUser())) {
                map.put("user", image.getUser());
            }
            if (StringUtils.isNotEmpty((CharSequence)image.getPassword())) {
                map.put("password", image.getPassword());
            }
            if (Objects.nonNull(image.getSshPort())) {
                map.put("ssh_port", image.getSshPort());
            }
            if (Objects.nonNull(image.getRdpPort())) {
                map.put("rdp_port", image.getRdpPort());
            }
            if (Objects.nonNull(image.getHttpConnection())) {
                map.put("http_port", image.getHttpConnection().getPort());
            }
            if (Objects.nonNull(image.getHttpsConnection())) {
                map.put("https_port", image.getHttpsConnection().getPort());
            }
            if (StringUtils.isNotEmpty((CharSequence)image.getVerifyTime())) {
                map.put("verify_time", image.getVerifyTime());
            }
            map.put("cloud_init", image.getCloudInit());
            map.put("hw_qemu_guest_agent", image.getHwQemuGuestAgent());
            map.put("telemetry_agent", image.getTelemetryAgent());
            map.put("status", ImageStatus.VERIFIED.toString());
            return Md5Utils.encode(Jacksons.toJSONString(map), "9bbf0936-fc81-dcc5-5555-c949b317817d");
        }
        return null;
    }

    private Map<String, String> getDefaultFilter() {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("limit", String.valueOf(100000));
        return filter;
    }

    private void updatePropertyToImageBuilder(ImageBuilder imageBuilder, LocalImage image) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vnc", image.getVnc());
        map.put("cloud_init", image.getCloudInit());
        map.put("cancel_verify", image.getCancelVerify());
        map.put("hw_qemu_guest_agent", image.getHwQemuGuestAgent());
        map.put("telemetry_agent", image.getTelemetryAgent());
        map.put("description", image.getDescription());
        map.put("cancel_verify_reason", image.getCancelVerifyReason());
        map.put("ssh_port", image.getSshPort());
        map.put("rdp_port", image.getRdpPort());
        map.put("http_connection", image.getHttpConnection());
        map.put("https_connection", image.getHttpsConnection());
        map.put("hw_disk_bus", image.getHwDiskBus());
        map.put("hw_vif_model", image.getHwVifModel());
        map.put("os_type", image.getOsType());
        map.put("flavor", image.getFlavor());
        map.put("user", image.getUser());
        map.put("password", image.getPassword());
        map.put("os_distro", image.getOsDistro());
        map.put("os_version", image.getOsVersion());
        map.put("architecture", image.getArchitecture());
        map.put("tags", image.getTags());
        map.put("vulnerabilities", image.getVulnerabilities());
        if (ScanStatus.SCAN_COMPLETED.equals((Object)image.getScanStatus())) {
            map.put("scan_status", (Object)image.getScanStatus());
        }
        if (ImageStatus.VERIFIED.equals((Object)image.getStatus())) {
            map.put("verify_time", image.getVerifyTime());
            map.put("sign", this.generateSign(image));
            map.put("status", (Object)image.getStatus());
        }
        map.put("verify_result", image.getVerifyResult());
        map.put("origin_disk_format", (Object)(Objects.nonNull((Object)image.getOriginDiskFormat()) ? image.getOriginDiskFormat() : image.getDiskFormat()));
        this.updateDiskBus(imageBuilder, image);
        this.updateVifModel(imageBuilder, image);
        this.updateQemu(imageBuilder, image);
        this.updateOsType(imageBuilder, image);
        imageBuilder.additionalProperty("image_properties", Jacksons.toJSONString(map));
        if (Strings.isNotBlank(image.getDescription())) {
            imageBuilder.additionalProperty("DESCRIPTION", image.getDescription());
            imageBuilder.additionalProperty("description", image.getDescription());
        }
        if (image.getMinDisk() != null) {
            imageBuilder.minDisk(Long.valueOf(image.getMinDisk().intValue()));
        }
        if (image.getMinRam() != null) {
            imageBuilder.minRam(Long.valueOf(image.getMinRam().intValue()));
        }
        if (image.getProtected() != null) {
            imageBuilder.isProtected(image.getProtected());
        }
        if (image.getImageVisibility() != null) {
            imageBuilder.visibility(Image.ImageVisibility.valueOf((String)image.getImageVisibility().name()));
        }
    }

    private void updateDiskBus(ImageBuilder imageBuilder, LocalImage image) {
        if (StringUtils.isNotEmpty((CharSequence)image.getHwDiskBus())) {
            imageBuilder.additionalProperty("hw_disk_bus", image.getHwDiskBus());
        }
    }

    private void updateVifModel(ImageBuilder imageBuilder, LocalImage image) {
        imageBuilder.additionalProperty("hw_vif_model", StringUtils.isBlank((CharSequence)image.getHwVifModel()) ? "virtio" : image.getHwVifModel());
    }

    private void updateQemu(ImageBuilder imageBuilder, LocalImage image) {
        if (Boolean.TRUE.equals(image.getHwQemuGuestAgent())) {
            imageBuilder.additionalProperty("hw_qemu_guest_agent", "yes");
        } else {
            imageBuilder.additionalProperty("hw_qemu_guest_agent", "no");
        }
    }

    private void updateOsType(ImageBuilder imageBuilder, LocalImage image) {
        if (StringUtils.isNotEmpty((CharSequence)image.getOsType())) {
            if ("other".equalsIgnoreCase(image.getOsType())) {
                imageBuilder.additionalProperty("os_type", "linux");
            } else {
                imageBuilder.additionalProperty("os_type", image.getOsType().toLowerCase());
            }
        }
    }
}

